#ifndef MBED_CLASSIC_PID_H
#define MBED_CLASSIC_PID_H
 
#include "mbed.h"
 
class Classic_PID {
public:
    /**
     * Constructor.
     *
     * Sets up PID loop.
     *
     * @param Kp - Tuning parameter
     * @param Ki - Tuning parameter
     * @param Kd - Tuning parameter
     * @param frequency PID calculation performed every interval seconds.
     */
    Classic_PID(float Kp, float Ki, float Kd, float kvelff);   //Kp, ki, kd, Loop frequency
    
    /**
     * Set the set point.
     *
     * @param sp The set point as a real world value.
     */
    void setSetPoint(float sp);
    
    /**
     * Set the process value.
     *
     * @param pv The process value as a real world value.
     */
    void setProcessValue(float pv);
    
    /**
     * PID calculation.
     *
     * @return The controller output as a float between 0 and 1.
     */
    float compute(void);
    
    /**
     * Set the Kp param.
     *
     * @param Kp The param as a real world value.
     */
    void setKp(float Kp);
    
    /**
     * Set the Ki param.
     *
     * @param Ki The param as a real world value.
     */
    void setKi(float Ki);
    
    /**
     * Get the Kp param.
     *
     * @returns the Kp param.
     */
    float getKp(void);
    
    /**
     * Get the Ki param.
     *
     * @returns the Ki param.
     */
    float getKi(void);
    
    /**
     * Get the Kvelff param.
     *
     * @returns the Kvelff param.
     */
    float getKvelff(void);
    
    /**
     * PID calculation usinf feed forward.
     *
     * @return The controller output as a float between 0 and 1.
     */
    float compute_ff(void);
    
    /**
     * Set the kvelff param.
     *
     * @param kvelff The param as a real world value.
     */
    void setKvelff(float Kvelff);
    
    /**
     * Set the process output limits.
     *
     * @param _maxLimit & _minLimit as a real world value.
     */
    void setProcessLimits(float maxLimit, float minLimit);
    
    /**
     * Get the current set point param.
     *
     * @returns the set point param.
     */
    float getSetPoint(void);
  
private:  
    float _Kp;
    float _Ki;
    float _Kd;
    float _frequency;
    
    float _setPoint;
    float _processVariable;
    int _sumError;
    int _lastError;
    double _lastOutput;
    double _output;
    float _kvelff;
    
    float _maxLimit;
    float _minLimit;
};
 
#endif