#include "mbed.h"
#include "BMP180.h"
#include "calculate.h"
#include "Movement.h"
#define PIN_SDA D4
#define PIN_SCL D5

DigitalOut Nichrome(A6);
 
int main(){
    BMP180 bmp180(PIN_SDA,PIN_SCL);
    int x = 0,y = 0,n1 = 0, n2 = 0;
    int i;
    float h,dp,dt,dp0;
    float a = 0,b = 0,dp_ave,dt_ave;
    //hは高度、dpは気圧、dtは温度、dp0は海面気圧
    bmp180.Initialize(27,BMP180_OSS_ULTRA_LOW_POWER);//27は府大の海抜高度
    
    //海面気圧を計算
    for(i=0;i<15;i++){
        if(bmp180.ReadData(&dt,&dp)){
            a = a + dp;
            b = b + dt;
            n1 = n1 + 1;
            n2 = n2 + 1;
            wait(1);
            }
        }
    
    dp_ave = a / n1;
    dt_ave = b / n2;    
    dp0 = calculate_dp0(dp_ave,dt_ave);
 
    //10秒以上高度10mにいた場合離陸判定       
    while(x<10){
            if(bmp180.ReadData(&dt,&dp)){
                h = calculate_h(dp0,dp,dt);
                if(h >= 15){
                x = x + 1;
                    }
                wait(1);
            }
    }
    wait(10);
 
  //離陸判定後、10秒以上高度2m以下にいた場合着地判定    
    while(y<10){
            if(bmp180.ReadData(&dt,&dp)){
                h = calculate_h(dp0,dp,dt);
                if(h <= 6){
                y = y + 1;
                    }
                wait(1);
            }
    }
    
    //30秒待機                
    wait(30);
 
    //パラシュート分離
    Nichrome=1;
    wait(10);
    Nichrome=0;    
    
    //前進して段差を上る、15m前進
    Movement idou;
    idou.move_backward();
    wait(180); 
    
    //右に45°方向転換して前進
    idou.turn_right(45);
    idou.move_backward();
    wait(5);
    
    //左に45°方向転換して前進
    idou.turn_left(45);
    idou.move_backward();
    wait(5);
    
    //右に90°方向転換して前進
    idou.turn_right(90);
    idou.move_backward();
    wait(5);
    
    //左に90°方向転換して前進
    idou.turn_left(90);
    idou.move_backward();
    wait(5);
    
    return 0;
    
}