#include "mbed.h"
 
//nの階乗を計算する関数
int fact(int n)
{
  int i, result = 1;
  
  if(n == 0)
    return 1;
  else
    {
      for(i = 1;i <= n;i++)
    {
      result *= i;
    } 
      return result;
    }
}
 
float my_pow(float x, int n)
{
  int i;
  float pow_result = 1;
 
  if(n == 0)
    return 1;
  else
    {
      for(i = 0;i < n;i++)
    {
      pow_result *= x;
    }
      return pow_result;
    }
}
 
float my_exp(float x)
{
  int i;
  float result = 0;
 
 
  for(i = 1;i <= 25; i++)
    {
      result += my_pow(x, i) / fact(i);
    }
 
  return result + 1;
}
 
float my_log(float x)
{
  int i;
  float result1, result2;
 
  x -= 1;
  result1 = 0;
  result2 = 0;
 
  for(i = 1;i <= 40;i++)
    {
      if(i % 2 == 1)
    result1 += my_pow(x, i) / i;
      else
 
    result2 += my_pow(x, i) / i;
    }
 
  return result1 - result2;
}
   
//累乗 
float mypow(float x, float y)
{
  return my_exp(y * my_log(x));
}
 
//高度計算
float calculate_h(float dP0FIX,float dp,float dt){
    float dpow = 1.0/5.256;
    float dP0 = 1013.25;
    float a = (dt+(float)273.15)/(float)0.0065;
    float s = (mypow(dP0/dp,dpow)- mypow(dP0/dP0FIX,dpow))*a - 27;
    return s;
    }
 
//海面気圧計算
float calculate_dp0(float dp,float dt){
    float s = dp*mypow(1 - (0.0065*27)/(dt+0.0065*27+273.15),-5.257);
    return s;
    }    