#include "mbed.h"
#include "MPU9250.h"



MPU9250 mpu9250(D4, D5);                   // SDA, SCL

Serial pc(USBTX, USBRX, 115200);

volatile bool interrupt_flag = false;

void detect_shock(void)
{
    interrupt_flag = true;
}

int main()
{


    mpu9250.resetMPU9250();
    mpu9250.setWakeOnMotion();

    while(1) {
        if (interrupt_flag) {

            pc.printf("detect\r\n");
            wait_ms(1000);
            interrupt_flag = false;
        }

        /* get accell data*/
        int16_t acc[3];
        mpu9250.readAccelData(acc);
        float acc_f[3];
        for (int i = 0; i < 3; ++i)
            acc_f[i] = float(acc[i]) * mpu9250.getAres();

        /* get temperature */
        float temperature = ((float) mpu9250.readTempData()) / 333.87 + 21.0;

        /* get gyro data*/
        int16_t gyro[3];
        mpu9250.readGyroData(gyro);
        float gyro_f[3];
        for (int i = 0; i < 3; ++i)
            gyro_f[i] = float(gyro[i]) * mpu9250.getGres();


        /* get mag data*/
        int16_t mag[3];
        mpu9250.readMagData(mag);
        float mag_f[3];
        for (int i = 0; i < 3; ++i)
            mag_f[i] = float(mag[i]) * mpu9250.getMres();







        /* serial */

        pc.printf("ax:%3.3f\t", acc_f[0]);
        pc.printf("ay:%3.3f\t", acc_f[1]);
        pc.printf("az:%3.3f\t\n", acc_f[2]);
        pc.printf("mx:%3.3f\t", mag_f[0]);
        pc.printf("my:%3.3f\t", mag_f[1]);
        pc.printf("mz:%3.3f\t\n", mag_f[2]);
        pc.printf("gx:%3.3f\t", gyro_f[0]);
        pc.printf("gy:%3.3f\t", gyro_f[1]);
        pc.printf("gz:%3.3f\t\n", gyro_f[2]);
        pc.printf("temp:%3.3f\t", temperature);

        pc.printf("\n\n---------------------------\r\n");

        wait_ms(100);
    }
}