/*

 
 Servo Motor:
 MG996R - http://www.electronicoscaldas.com/datasheet/MG996R_Tower-Pro.pdf
 
 RED    - + Vcc from 4,5 to 7,2V
 BLACK  - GND
 ORANGE - PWM
 
  Duty - example: 1.9 (mS)
  \  / 
   \/
   __
__|  |_____________
     ... 20mS......
     
 For rotate to right use value 1 for Duty
 For rotate to left use value 5 for Duty
  
 Vedere queste spiegazioni: 
 http://www.adrirobot.it/servotester/il_servomotore.htm
 
 
 
 NOTE:
 
 For rotate to Right (DESTRA) use this command:
 Move(Right);
 For rotate to Left (SINISTRA) use this command:
 Move(Left);
 
 You also has the possibility to send a command like below:
 Move(1.5):
  
*/

#include "mbed.h"

DigitalOut Drive(PA_10);

#define PWMoff 20 // Waiting for end PWD
#define Right   1 // Move to Right -> DESTRA   or DX
#define Left    5 // Move to LEFT  <- SINISTRA or SX
#define DLY     1

void Move(double);

double p=0;


int main() 
{  
int n=0;

    printf("By: www.emcu.eu - Ver.1.0 \n\r");

    printf("Rotate all to -> \n\r");
    // Sposta tutto a DX 
    for(n=0; n<20; n++)
        Move(Right);

    wait(DLY);

    printf("Rotate all to <- \n\r");
    // Sposta tutto a SX 
    for(n=0; n<20; n++)
        Move(Left);
    
    wait(DLY);
    
    printf("Move to 10 times to ->\n\r");
    for(n=0; n<10; n++)
        Move(Right);
    
    wait(DLY);
    
    printf("END \n\r\n\r");
}


void Move(double ON)
{ 

Drive=1;
wait_ms(ON);
Drive=0;
wait_ms(20);

}



/*

    // Sposta tutto a DX - Move all to RIGHT
    for(n=0; n<200; n++)
        Move(Right);

    wait(DLY);

    // Sposta tutto a SX - Move all to LEFT
    for(n=0; n<200; n++)
        Move(Left);
    
    wait(DLY);

*/

/*
        p=0.4;
        myservo = p;
        printf("P = %.2f \n\r", p);
        wait(0.2);
*/ 
