#include "mbed.h"
#include"getGPS.h"



Serial xbee(PA_9, PA_10);
GPS gps(PA_2,PA_3);
int end_flag=0;
double bias_la=0,bias_lo=0;

int main()
{    
    
    xbee.printf("XBee Connected\r\n");
    xbee.printf("start command\t(S or s)\r\nend command\t(C or c)");

    while(1){
        
        int received_data = xbee.getc();//command
        xbee.printf("\r\n---------------\r\nReceived Data: %c\r\n", received_data);
        
        if(received_data == 83 || received_data == 115) 
        { //S or s
            double goal_latitude,goal_longitude;
            xbee.printf("Mission Start\r\n");
            xbee.printf("please enter goal latitude:");
            xbee.scanf("%lf",&goal_latitude);
            xbee.printf("\r\nplease enter goal longitude:");
            xbee.scanf("%lf",&goal_longitude);
            xbee.printf("\r\n--------------\r\nstart GPS\r\n------------------\r\n");
            end_flag=0;
            
            
            while(end_flag==0)
            {
                xbee.printf("1");//確認用表示(後で消去)
                if(gps.getgps())
                { //現在地取得
                    xbee.printf("(latitude:%lf, longitude:%lf)\r\n", gps.latitude, gps.longitude);//緯度と経度を出力
                    
                }else{
                
                    xbee.printf("No data\r\n");//データ取得に失敗した場合
                    }
                    
                //目的地到達判定
                if(abs(gps.latitude-double(goal_latitude))<=bias_la&&abs(gps.longitude-double(goal_longitude))<=bias_lo)
                {
                    xbee.printf("potion match\r\n");
                    end_flag=1;
                }else if(abs(gps.latitude-double(goal_latitude))>bias_la||abs(gps.longitude-double(goal_longitude))>bias_lo){
                    xbee.printf("\r\n-----\r\n(latitude bias:%lf,longitude bias:%lf)\r\n",gps.latitude-double(goal_latitude),gps.longitude-double(goal_longitude));
                
                }
                wait(0.5);
                
            }
            
        
        }else if(received_data == 67 || received_data == 99){
             //C or c
            xbee.printf("%c\r\n", received_data);
            xbee.printf("Mission Complete\r\n");
            break;
            }
            break;
        }
return 0;
        }
        
        