#include "mbed.h"
#include "VNH5019.h"

VNH5019 motorShield(p23,p22,p25,p21,p24,p26);
Serial pc(USBTX, USBRX);
Serial xbee(p13, p14);

int main()
{
    xbee.baud(57600);
    pc.baud(57600);

    char c;

    while(true) {
        c = xbee.getc();

        // front
        if(c == 'f') {
            xbee.printf("f\n");
            motorShield.changeSpeed(1, 64, 1, 64);
        }
        
        // back
        if(c == 'b'){
            xbee.printf("b\n");
            motorShield.changeSpeed(2, 64, 2, 64);
        }
        
        // left
        if(c == 'l'){
            xbee.printf("l\n");
            motorShield.changeSpeed(1, 32, 1, 64);
        }
        
        // right
        if(c == 'r') {
            xbee.printf("r\n");
            motorShield.changeSpeed(1, 64, 1, 32);
        }

        // stop
        if(c == 's') {
            xbee.printf("s\n");
            motorShield.changeSpeed(0, 64, 0, 64);
        }
    }
    return 0;
}