#ifndef CANSAT_H
#define CANSAT_H

/**
 * Includes
 */
#include "mbed.h"
#include "VNH5019.h"
enum STATUS {GPS_AVAIL = 0, GPS_UNAVAIL = 1,GPS_OUT_AREA = 2};

const int distance_threshold[2]={0.1,0.5};

class CanSat{
    public:
        STATUS nowStatus;
    
        char motor_command;
        void control_Motor(int,int);//動き、スピード
    
        CanSat(VNH5019 agzSheild);
        //ロボットとターゲットの方角からロボットの動きを決める
        char get_moving_angle(int robot_angle,int target_angle);
        //ロボットとターゲットの距離の計算
        double get_taget_distance();
        //ロボットとターゲットの距離から速度を決める
        int get_roboto_velocity();
        //気圧の取得
        double get_pressure();
        //スタック判定：加速度データをもとに？
        bool is_stack();
        //ログデータの送信
        void log_send();
        
        //get関数
        double get_robot_x();
        double get_robot_y();
        double get_robotKalman_x();
        double get_robotKalman_y();
        int16_t get_compass_x();
        int16_t get_compass_y();
        int16_t get_compass_z();
        double get_compass_angle();
        double get_target_distance();
        double get_target_x();
        double get_target_y();
        
        int get_speed();
        int get_robot_angle();
        int get_target_angle();

        double get_temperature();
        double get_humidity();
        
        //set関数
        void set_robot_x(double);
        void set_robot_y(double);   
        void set_robotKalman_x(double);
        void set_robotKalman_y(double);
    
        void set_gyro(double x, double y, double z);
        void set_compass(int16_t x, int16_t y, int16_t z, double angle);
        void set_pressure(double p);
        void set_temperature(double t);
        void set_humidity(double h);
        void set_acceleration(double x, double y, double z);
        
        void set_target_distance(double distance);
        void set_speed(int new_speed);
        void set_robot_angle(int robot_angle);
        void set_target_angle(int target_angle);
        void set_target(double x, double y);

    private:
        //モータ
        VNH5019 _agzSheild;
        //ロボットのスピード:32,64,128の3つ？
        int speed;
        //ロボットとターゲットの座標（緯度と経度）を表す
        double robot_x,robot_y;
        double robotK_x,robotK_y;//kalman filter
        double target_x, target_y;
        //ロボットとターゲットの方角を表す。北を0として北東：1、東：1、南東3のように0～7の値を持つ
        int robot_angle,target_angle;
        //ジャイロ
        int gyro_x,gyro_y,gyro_z;
        //コンパス
        int compass_x,compass_y,compass_z;
        double compass_angle;
        //加速度
        double acceleration_x,acceleration_y,acceleration_z;
        //気圧計の気圧、気温、湿度
        double pressure,temperature,humidity;
        //ロボットの速度
        int velocity;
        //ターゲットまでの距離
        int target_distance;
};

#endif
