/**********************************************/
//更新情報

/**********************************************/

#include "mbed.h"
#include "XBee.h"
#include "MBed_Adafruit_GPS.h"
//#include "AigamozuControlPackets.h"
#include "agzIDLIST.h"
#include "aigamozuSetting.h"
#include "HMC5883L.h"
#include "VNH5019.h"
#include "cansat.h"
#include "math.h"
#include "BME280.h"

#define SIGMA_MIN 0.0001

#define STOP 0 //compass initial
#define CAL 1 //compass calibration
#define RUN 2 //compass run

/////////////////////////////////////////
//
//Pin Setting
//
/////////////////////////////////////////
VNH5019 agz_motorShield(p23,p22,p25,p21,p24,p26);
//VNH5019 agz_motorShield(p21,p22,p23,p24,p25,p26);

/////////////////////////////////////////
//
//Connection Setting
//
/////////////////////////////////////////

//Serial Connect Setting: PC <--> mbed
Serial pc(USBTX, USBRX);    

//Serial Connect Setting: GPS <--> mbed
Serial * gps_Serial;

//Serial Connect Setting: XBEE <--> mbed
Serial xbee(p13,p14);
ZBRxResponse zbRx = ZBRxResponse();

// compass
HMC5883L compass(p9, p10);

//set up GPS module

//set up AigamozuControlPackets library
//AigamozuControlPackets agz(agz_motorShield);
CanSat cansat(agz_motorShield);

//set up for tempratures...
#if defined(TARGET_LPC1768)
BME280 sensor(p9, p10);
#else
BME280 sensor(I2C_SDA, I2C_SCL);
#endif

DigitalIn short_in(p29);
DigitalOut short_out(p30);
DigitalInOut nic(p5);

Timer compass_Timer;
const int compass_Time = 500;
/////////////////////////////////////////
//
//For Compass data
//
/////////////////////////////////////////
Ticker compass_interrupt;
double heading0 = 0.0;    
double heading1 = 0.0;
double heading2 = 0.0;
double heading3 = 0.0;
double headingLPF = 0.0;
double initHeading;
double tgtHeading;
double preHeading = 0.0;
 
int maxX, minX, maxY, minY;
const int ofsX = 46;                   //calibration x
const int ofsY = -950;                   //calibration y

    int16_t raw[3]; 

/////////////////////////////////////////
//
//For Kalman data
//
/////////////////////////////////////////
#define FIRST_S2_1 1.0e-8
#define FIRST_S2_2 1.0e-6
#define COUNTER_MAX 10000
#define ERROR_RANGE 0.001

double x_cur,x_prev,y_cur,y_prev;//緯度と経度の時刻tと時刻t-1での推定値
double s2x_cur=FIRST_S2_1,s2x_prev=FIRST_S2_1,s2y_cur=FIRST_S2_1,s2y_prev=FIRST_S2_1;//緯度経度のの時刻tと時刻t-1での共分散
double s2_R=FIRST_S2_2;//GPSセンサの分散
double s2_Q=FIRST_S2_2;
double Kx=0,Ky=0;//カルマンゲイン
double zx,zy;//観測値
void Kalman(double Latitude,double Longitude);
int change = 0;

int mode = 2; //ロボットのモード
double target_x = 40.085592,target_y = 139.592383;
double  goal_Pressure, goal_Temperature,goal_Humidity; //地表地点の気圧、気温、湿度

Timer sep_Timer;
const int sep_Time = 30000; //seperate time in ms
int fall_flag = 0;

int log_number = 0;


/////////////////////////////////////////
//
//Kalman Processing
//
/////////////////////////////////////////
void calc_Kalman(){
  //calc Kalman gain
  Kx = (s2x_prev+s2_Q)/(s2x_prev+s2_R+s2_Q);
  Ky = (s2y_prev+s2_Q)/(s2y_prev+s2_R+s2_Q);
  //estimate
  x_cur = x_prev + Kx*(zx-x_prev);
  y_cur = y_prev + Ky*(zy-y_prev);
  //calc sigma
  s2x_cur = (1-Kx)*(s2x_prev+s2_Q);
  s2y_cur = (1-Ky)*(s2y_prev+s2_Q);

}

void Kalman(double Latitude,double Longitude){

    zx = Latitude;
    zy = Longitude;

    calc_Kalman();
    
    //更新
    x_prev = x_cur;
    y_prev = y_cur;
    s2x_prev = s2x_cur;
    s2y_prev = s2y_cur;
    
    //robotK\x,robotK_yに格納する
    cansat.set_robotKalman_x(x_cur);
    cansat.set_robotKalman_y(y_cur);
}

/////////////////////////////////////////
//
//Get GPS function
//
/////////////////////////////////////////

void Get_GPS(Adafruit_GPS *myGPS){
    static int flag = 0;
    
    if (myGPS->fix) {
        
        cansat.nowStatus = GPS_AVAIL;
        cansat.set_robot_x((double)myGPS->latitudeH + (double)(myGPS->latitudeL / 1000000.0));
        cansat.set_robot_y((double)myGPS->longitudeH +(double)(myGPS->longitudeL / 1000000.0));
    
        
        if(flag < COUNTER_MAX){
            flag++; 
        }
        if(flag == 5){
            x_prev = cansat.get_robot_x();
            y_prev = cansat.get_robot_y();
        }
            
        if(flag >= 6){
            if(abs(x_prev - cansat.get_robot_x()) < ERROR_RANGE && abs(y_prev - cansat.get_robot_y()) < ERROR_RANGE){
                Kalman(cansat.get_robot_x(), cansat.get_robot_y());
                change = 1;
            }
            else{
                change = 0;
            }            
                //printf("%.14lf %.14lf %.14lf %.14lf %.14le %.14le \n",
                //agz.get_agzPoint_lati(),agz.get_agzPoint_longi(),
                //agz.get_agzPointKalman_lati(),agz.get_agzPointKalman_longi(),
                //agz.get_agzCov_lati(),agz.get_agzCov_longi());
        }
    }
    else cansat.nowStatus = GPS_UNAVAIL;
    
} 

//ロボットの動き方
char robot_Action(int robot_angle, int target_angle) {
    
    int n, t, r;
    t = target_angle;
    r = robot_angle;
    n = r - t;
    if(n<0) n *= -1;
    
    
    if(t==r) {
        //前進
        return 'f';
    } else if(n < 4) {
        if(t > r)
            t -= 8;
        else
            r -= 8; 
            
        if(r-t > 0)
            return 'l';
        else
            return 'r';
    } else if(n >= 4) {
        if(t > r)
            t -= 8;
        else
            r -= 8; 
            
        if(r-t > 0)
            return 'r';
        else
            return 'l';
    }
    
    return 'b';
}

//対象とロボットの角度
double robot_compass(double robot_x, double robot_y) {
    double angle = 0;
    
    if(robot_x==0&&robot_y>0)
        return 0;
    else if(robot_x>0&&robot_y==0) //東
        return 90;
    else if(robot_x==0&&robot_y<0) //南
        return 180;
    else if(robot_x<0&&robot_y==0) //西
        return 270;
    else if(robot_x>=0&&robot_y>=0) { //北東
        if(robot_x<=robot_y)
            angle = atan2(robot_x, robot_y);
        else
            angle = (M_PI/2) - atan2(robot_y, robot_x);
        return angle * 180.0 / M_PI;
    } else if(robot_x>=0&&robot_y<0) { //南東
        if(robot_x>abs(robot_y)){
            angle = (M_PI/2) - atan2(abs(robot_y), robot_x);
        }
        else{
            angle = atan2(abs(robot_y), robot_x);
        }
        return angle * 180.0 / M_PI + 90;
    } else if(robot_x<0&&robot_y<0) { //南西
        if(abs(robot_x)<abs(robot_y)){
            angle = atan2(abs(robot_x), abs(robot_y));
        }
        else{
            angle = (M_PI/2) - atan2(abs(robot_y), abs(robot_x));
        }
        return angle * 180.0 / M_PI + 180;
    } else if(robot_x<0&&robot_y>=0) { //北西
        if(abs(robot_x)>robot_y){
            angle = (M_PI/2) - atan2(robot_y, abs(robot_x));
        }
        else{
            angle = atan2(abs(robot_x), robot_y);
        }
        return 360 - angle * 180.0 / M_PI;
    }
    
    return -1;
}

int calc_angle(double c){
    if(c > 337.5 ||(c >=0 && c < 22.5)) return 0;
    else if(c >= 22.5 && c < 67.5) return 1;
    else if(c >= 67.5 && c < 112.5) return 2;
    else if(c >= 112.5 && c < 157.5) return 3;
    else if(c >= 157.5 && c < 202.5) return 4;
    else if(c >= 202.5 && c < 247.5) return 5;
    else if(c >= 247.5 && c < 292.5) return 6;
    else if(c >= 292.5 && c < 337.5) return 7;
    else return 8;
}  

void Compass_intrpt(){    
   
    compass.getXYZ(raw);
    double heading = atan2(static_cast<double>(raw[2]-ofsY), static_cast<double>(raw[0]-ofsX)); //y=raw[2]
    if(heading < 0)heading += 2*M_PI;
    if(heading > 2*M_PI)heading -= 2*M_PI;
    heading3 = heading2;
    heading2 = heading1;
    heading1 = heading0;
    heading0 = heading;
    headingLPF = (heading0 + heading1 + heading2 + heading3)/4; //low pass filter

    headingLPF = headingLPF * 180.0 / M_PI;
    //  pc.printf("heading=%f\r\n",headingLPF);

    cansat.set_compass(raw[0], raw[2], raw[1], headingLPF);
    cansat.set_robot_angle(calc_angle(headingLPF));
}

    
/******************************
スタンバイモード
******************************/
void standby(){
    
    cansat.control_Motor(1, cansat.get_speed());
    if(short_in == 0){
        mode = 1;
        xbee.printf("change mode: falling\n");
    }
    
}

/******************************
落下モード
******************************/
void falling_print(){
    
    xbee.printf("%d times, x:%f, y:%f, speed:%d\n", log_number, cansat.get_robot_x(), cansat.get_robot_y(), cansat.get_speed());
    xbee.printf("Pressure:%04.2f hPa\n", cansat.get_pressure());

    log_number++;
    
}

void falling(){
    
    cansat.set_temperature(sensor.getTemperature()); 
    cansat.set_pressure(sensor.getPressure());
    cansat.set_humidity(sensor.getHumidity());
    
    if(cansat.get_pressure() >= goal_Pressure){
        if(fall_flag == 0){
            nic = 1;
            fall_flag = 1;
            sep_Timer.reset();
        }
        if(sep_Timer.read_ms() >= sep_Time){
            mode = 2;
            nic = 0;
            xbee.printf("change mode: running\n");
        }

    }    

    falling_print();

}

/******************************
走行モード
******************************/

void running_print(){
    
    xbee.printf("%d times, x:%f, y:%f, speed:%d\n", log_number, cansat.get_robot_x(), cansat.get_robot_y(), cansat.get_speed());
    xbee.printf("moter command: %c\n", cansat.motor_command);
    xbee.printf("robot_angle:%d, target_angle:%d, robot_compass:%f, prressure:%04.2f hPa\n",cansat.get_robot_angle(), cansat.get_target_angle(),  cansat.get_compass_angle(), cansat.get_pressure());

    log_number++;
    
}

void running(){
    
    double r = 6378.137;
    double y1 = cansat.get_target_y();
    double y2 = cansat.get_robot_y();
    double x1 = cansat.get_target_x();
    double x2 = cansat.get_robot_x();
    double dx = x2 - x1;
    
    cansat.set_target_distance(r*acos(sin(y1)*sin(y2)+cos(y1)*cos(y2)*cos(dx)));
    cansat.set_target_angle(calc_angle(robot_compass(x1-x2, y1-y2)));
    
    if(cansat.get_target_distance() < 10) cansat.set_speed(32);
    else if(cansat.get_target_distance() < 20 && cansat.get_target_distance() > 10) cansat.set_speed(64);
    else cansat.set_speed(128);
    
    if(compass_Timer.read_ms() >= compass_Time){
        compass_Timer.reset();
        if(cansat.get_compass_z() < 0) {
            //ひっくり返っている
            cansat.control_Motor(0, cansat.get_speed());
        } else {
            cansat.motor_command = robot_Action(cansat.get_robot_angle(), cansat.get_target_angle());
            switch(cansat.motor_command) {
                case 'f': //前進
                    cansat.control_Motor(0, cansat.get_speed());
                    break;
                case 'l':
                    cansat.control_Motor(2, cansat.get_speed());
                    break;
                case 'r':
                    cansat.control_Motor(3, cansat.get_speed());
                    break;
                case 'b':
                    cansat.control_Motor(4, cansat.get_speed());
                    break;
            }
        }
    }
    if(cansat.get_target_distance() <= 1){
        mode = 100;
        xbee.printf("change mode: stopping\n");
        xbee.printf("it is goal point.\n");
    }
    
    running_print();
}

/******************************
停止モード
******************************/
void stopping(){
            
            cansat.control_Motor(1, cansat.get_speed());
            
}

/////////////////////////////////////////
//
//Main Processing
//
/////////////////////////////////////////
int main() {
    //start up time
    wait(3);
    //set pc frequency to 57600bps 
    pc.baud(PC_BAUD_RATE); 
    //set xbee frequency to 57600bps
    //xbee.begin(XBEE_BAUD_RATE);    
    xbee.baud(9600);    
    //Compass setting
    compass.init();

    //GPS setting
    gps_Serial = new Serial(p28,p27);
    Adafruit_GPS myGPS(gps_Serial); 
    Timer refresh_Timer;
    const int refresh_Time = 1000; //refresh time in ms
    Timer running_Timer;
    const int running_Time = 500;
    int count = 0;

    myGPS.begin(GPS_BAUD_RATE); 
    
    //GPS Send Command
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCONLY); 
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    
    wait_ms(2000);
       
    //interrupt start
    refresh_Timer.start();
    compass_Timer.start();
    running_Timer.start(); 
    cansat.set_target(target_x, target_y);
   // wait_ms(10000);

    compass_interrupt.attach(&Compass_intrpt, 0.5);

    printf("start\n");
    
    //int mode = -1;
    short_out = 1; //ショートピンの出力:high
    nic.output();
    nic = 0;
    
    while (true) {

        switch(mode){
            //スタートモード：パラシュートが開くまではこのモードを実行
            case -1:
                standby();
            break;
            //落下モード：落下時はこのモード。気圧計または、時間でロボットとパラシュートを分離する
            case 1:
                falling();
            break;
            //走行モード：ターゲットにむかって走行を行う
            case 2:
                if (running_Timer.read_ms() >= running_Time) {
                    running_Timer.reset();
                    running();
                }
            break;
            //停止モード：ターゲット
            case 100:
                stopping();
            break;
        }
        
   /*     while(1){
            
            printf("compass x : %i, compass y : %i, compass z : %i\n", raw[0], raw[1], raw[2]);
            printf("set compass x : %i, set compass y : %i, set compass z : %i\n", cansat.get_compass_x(), cansat.get_compass_y(), cansat.get_compass_z());
            printf("compass angle : %f\n", headingLPF);
            printf("set compass angle : %f\n", cansat.get_compass_angle());
            printf("robot angle : %d\n", calc_angle(headingLPF));
            printf("set robot angle : %d\n", cansat.get_robot_angle());
        }
*/
        myGPS.read();
        //recive gps module
        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;   
            } 
            else{
                count++;
            }    
        }
        //一定時間ごとに自分のGPSデータを取得し、AigamozuControlPacketsないのagzPointとagzPointKalmanに格納する
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            //print_gps(count);
            Get_GPS(&myGPS);
            //log++;
 /*           xbee.printf("%d times, x:%f, y:%f, speed:%d\n", log, cansat.get_robot_x(), cansat.get_robot_y(), cansat.get_speed());
            xbee.printf("moter command: %c\n", cansat.motor_command);
            xbee.printf("robot_angle:%d, target_angle:%d, robot_compass:%f, %04.2f hPa\n",cansat.get_robot_angle(), cansat.get_target_angle(),  cansat.get_compass_angle(), cansat.get_pressure());
 */
        }
    }
    
}