#include "mbed.h"
#include "VNH5019.h"

#define M_PI 3.1415926535897932384626433832795
class Cansat2016
{

private:
    typedef struct {
        double x;           // latitude
        double y;           // longitude
        int direction;      // compass
    } BasicData;

    // robot data, target data
    BasicData robot, target;
    // distance of robot and target
    double sub_x, sub_y;
    double distance;
    // motor
    VNH5019 _motor;
    // speed of robot
    int speed;
    // action of robot
    char action;

public:
    // constructor
    Cansat2016(VNH5019 motor);

    void calc_distance(void);
    void robot_compass(DigitalIn *sensor);
    void target_compass();
    void robot_action(void);
    void motor_control(void);

    // set
    void set_robotGPS(double x, double y);
    void set_targetGPS(double x, double y);
    void set_action(char a);
    void set_speed(int value);

    // get 
    double get_x(void);
    double get_y(void);
    int get_compass(char c);
    double get_distance(void);
    char get_action(void);
};
