#include "VNH5019.h"

#include "mbed.h"
#include <stdint.h>
#include <math.h>
#include <ctype.h>

//PinSetting
VNH5019::VNH5019(PinName m1na,PinName m1nb,PinName m1pwm,PinName m2na,PinName m2nb,PinName m2pwm) 
    : _m1na(m1na),_m1nb(m1nb),_m1pwm(m1pwm),_m2na(m2na),_m2nb(m2nb),_m2pwm(m2pwm){
        _m1pwm.period_us(50);
        _m2pwm.period_us(50);
    }
    
void VNH5019::changeSpeed(uint8_t L_state,uint8_t L_pwm,uint8_t R_state,uint8_t R_pwm){
    
        switch(L_state){
        case 0:
            _m1na = 0;
            _m1nb = 0;
            break;
        
        case 1:
            _m1na = 1;
            _m1nb = 0;
            break;        
        
        case 2:
            _m1na = 0;
            _m1nb = 1;
           break;
           
        default: 
            _m1na = 0;
            _m1nb = 0;     
            break;
        }
    
    _m1pwm = (float)L_pwm/256.0;
    
        switch(R_state){
        case 0:
            _m2na = 0;
            _m2nb = 0;
            break;
        
        case 1:
            _m2na = 1;
            _m2nb = 0;
            break;        
        
        case 2:
            _m2na = 0;
            _m2nb = 1;
           break;
           
        default: 
            _m2na = 0;
            _m2nb = 0;     
            break;
        }
    
    
    _m2pwm = (float)R_pwm/256.0;
    
    }