#include "mbed.h"
#include "us015.h"


// コンストラクタ
US015::US015(PinName trg, PinName ech)
    :_trigerOut(trg),_interruptEcho(ech)
{
    // タイマーの開始
    timer.start();
    // トリガー信号の定期出力を行う
    //tk.attach_us(this,&US015::TrigerOut,US015_PERIODIC_TRIGER);
    // エコーバック信号の立ち上がり・立ち下がり処置の割り込み
    _interruptEcho.fall(this,&US015::EchoFall);
    _interruptEcho.rise(this,&US015::EchoRise);
}
// End of Constructor


//  トリガー信号を出力する
void US015::TrigerOut()
{
    // トリガー出力として10[us]のパルス信号を出す
    _trigerOut = US015_TRIGER_ON;
    wait_us(US015_TRIGER_PALUSE_WIDTH);    
    _trigerOut = US015_TRIGER_OFF;
}
// End of TrigerOut


// 距離情報の取得
float US015::GetDistance()
{
    return distance;    
}
// End of GetDistance

// エコーの信号の立ち下がり
void US015::EchoFall()
{   
    //エコー信号の立ち下がり時間を取得
    tmEnd=timer.read_us();

    // 反射面距離の計算(往復の距離を音速と経過時間から求め、その半分を片道の距離とする)
    // (エコー受信時間 - トリガー発信時間)* 音速0.340[mm/us]/2
    distance = (((double)tmEnd-(double)tmBegin)*(0.340))/2;
}
// End of EchoFall


// エコーの信号の立ち上がり処理
void US015::EchoRise()
{
    //エコー信号の立ち上がり時間を記録
    tmBegin=timer.read_us();
}
// End of EchoRise
