#ifndef __US015_H
#define __US015_H

#include "mbed.h"


//====================================
// define定義
//====================================
#define US015_TRIGER_ON             1    // トリガーON
#define US015_TRIGER_OFF            0    // トリガーOFF
#define US015_TRIGER_PALUSE_WIDTH   10   // トリガーの幅
#define US015_PERIODIC_TRIGER 100000    // 音響測距トリガー
#define US015_SOUND_OF_SPEED  0.340           // 音速[mm/us]


//====================================
// 音響測距センサ(US015)の制御クラス
//====================================
class US015
{
    public:
        US015(PinName trg, PinName ech);
        US015(PinName trg, PinName ech, float tkTime);
        float GetDistance();
        void TrigerOut();                       // トリガー出力
        
    private:
        DigitalOut _trigerOut;                  // U015トリガー出力
        InterruptIn _interruptEcho;             // U015エコー入力
        Timer timer;                            // 時間計測用のタイマ
        Ticker tk;                              // 周期処理用のチッカー
        float tmBegin;                          // エコーの立ち上がり時間
        float tmEnd;                            // エコーの立ち下がり時間
        float distance;                         // 距離測定
        void EchoFall();                        // エコーの立ち下がり処理
        void EchoRise();                        // エコーの立ち上がり処理
};

#endif