#include "mbed.h"
#include "TB6612.h"
#include "HMC6352.h"
#include "us015.h"

TB6612      motor_a(D10,D6,D7);  //モータA制御用(pwma,ain1,ain2)
TB6612      motor_b(D11,D8,D9);  //モータB制御用(pwmb,bin1,bin2)
Serial      pc(USBTX,USBRX);    //USBシリアル通信用
HMC6352 compass(D4, D5);
US015 hs(D2,D3);
int d;
int n;

int motor(char m) {
    float   motor_speed;        //モータスピード情報格納用
        while(1) {
        motor_speed=0.5; //モータスピード(低速運転させるため２分の１の値とする。)
        switch(m)
        {
            case    '1':    motor_a=motor_speed;    //モータA正転
                            break;    
            case    '2':    motor_a=0;              //モータAブレーキ
                            break;
            case    '3':    motor_a=-motor_speed;   //モータA逆転
                            break;                                        
            case    '7':    motor_b=motor_speed;    //モータB正転
                            break;    
            case    '8':    motor_b=0;              //モータBブレーキ
                            break;
            case    '9':    motor_b=-motor_speed;   //モータB逆転
                            break;              
            default    :    motor_a=0;
                            motor_b=0;              //両方モータブレーキ
                            break;        
        }
    }
}

int Compass()
{
    int angle;
    compass.setOpMode(HMC6352_CONTINUOUS, 1, 20);
    angle = compass.sample() / 10;
    return angle;
}

int Sonic()
{
    int distance;
    distance = hs.GetDistance();
    return distance;
}

int main()
{
    motor(1);
    motor(7);
    while(1)
    {
        n = Compass();
        if(n >= 5) {    //5°ずれると片方のモーターが逆転する
        motor(3); 
        wait(5.0);
        }
        else {
        motor(1);
        motor(7); 
        }
        
        d = Sonic();
        if(d<=2000){    //超音波反応
        motor(3);  
        wait(5.0);
        motor(1);
        }
    }
}