// モータを制御する関数
#include "TB6612.h"

TB6612 motor_a(D10,D6,D7);  //モータA制御用(pwma,ain1,ain2)
TB6612 motor_b(D11,D8,D9);  //モータB制御用(pwmb,bin1,bin2)
//Serial pc(USBTX, USBRX);

void MotorDriver(char input_data, float motor_speed) {
    switch (input_data) {
        case '1':  // 停止
            motor_a = 0;
            motor_b = 0;
            break;
        case '2':  // 前進
            motor_a = motor_speed;
            motor_b = motor_speed;
            break;
        case '3':  // 後退
            motor_a = -motor_speed;
            motor_b = -motor_speed;
            break;
        case '4':  // 時計回りに回転
            motor_a = motor_speed;
            motor_b = -motor_speed;
            break;
        case '5':  // 反時計回りに回転
            motor_a = -motor_speed;
            motor_b = motor_speed;
            break;
        case '6':  // Aのみ正転
            motor_a = motor_speed;
            break;
        case '7':  // Bのみ正転
            motor_b = motor_speed;
            break;
        case '8':  // Aのみ逆転
            motor_a = -motor_speed;
            break;
        case '9':  // Bのみ逆転
            motor_b = -motor_speed;
            break;
        default:
            // エラーメッセージを返す
            break;
    }
    pc.printf("%d", input_data);
}