#include "mbed.h"
#pragma once

#define AQTK_I2C_ADDR (0x2E<<1)//スレイブアドレス
#define AQTK_STARTUP_WAIT_MS 80
#define AQTK_POLL_WAIT_MS 10

class ATP3011 {
public:
    /** Create a AquesTalk pico LSI I2C interface
     *
     * @param sda  I2C data pin
     * @param scl  I2C clock pin
     * @param addr I2C address
     */
    ATP3011(PinName sda, PinName scl, int addr = AQTK_I2C_ADDR);
    bool IsActive(int timeout_ms = 500);
    void Synthe(const char* msg);
    void Write(const char* msg);
    bool IsBusy();
private:
    int _addr; 
    I2C _i2c; //mbed I2Cで検索
    Timer _poll_wait; //mbed Timer時間で検索
};
