/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46z_Torreta
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "mbed.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|   Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker Barrido;                             // Interrupción del Timer
BusOut Torreta(PTE16, PTE17, PTE18, PTE19, PTE20, PTE21, PTE22, PTE23);

/*
+-------------------------------------------------------------------------------
|   Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint8_t Secuencias[]={
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0,
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0, 
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0,
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00,
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00,
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00,
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00,
        0x18, 0x24, 0x18, 0x24, 0x18, 0x24, 0x18, 0x24,
        0x18, 0x24, 0x18, 0x24, 0x18, 0x24, 0x18, 0x24,
        0x04, 0x08, 0x10, 0x20, 0x04, 0x08, 0x10, 0x20,
        0x04, 0x08, 0x10, 0x20, 0x04, 0x08, 0x10, 0x20,
        0x20, 0x10, 0x08, 0x04, 0x20, 0x10, 0x08, 0x04,
        0x20, 0x10, 0x08, 0x04, 0x20, 0x10, 0x08, 0x04,
        0x04, 0x08, 0x10, 0x20, 0x20, 0x10, 0x08, 0x04,
        0x04, 0x08, 0x10, 0x20, 0x20, 0x10, 0x08, 0x04,
        0x88, 0x44, 0x11, 0x22, 0x88, 0x44, 0x22, 0x11,
        0x88, 0x44, 0x11, 0x22, 0x88, 0x44, 0x22, 0x11,
        0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88,
        0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88,
        0x3C, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0xC3, 0x00,
        0x3C, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0xC3, 0x00,
        0x3C, 0x3C, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00,
        0x3C, 0x3C, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00,
        0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00,
        0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00,
        0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C,
        0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C,
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C,
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C,
        0xF0, 0x30, 0x0C, 0x0F, 0x0C, 0x30, 0xF0, 0xC0,
        0xF0, 0x30, 0x0C, 0x0F, 0x0C, 0x30, 0xF0, 0xC0,
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03,
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03,
        0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xF0,
        0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xF0,
        0x00, 0xF0, 0x00, 0x0F, 0x00, 0xF0, 0x00, 0x0F,
        0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF };

uint16_t No_Secuencias=304;     // Número de secuencias a desplegar
uint16_t i=0;                   // Indice para las secuencias
uint16_t delay=250;             // Tiempo de retardo entre secuencias (en ms)
uint16_t contador=0;            // Contador de mili segundos

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|   Definición de Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void)
{
    /* Rutina de Atención a la Interrupción */
    /* Write your code here ... */
    
    contador++;                     // Incremeta el contador de mili segundos
    if (contador == delay)          // Contador es igual al retardo programado?
    {
    Torreta=Secuencias[i];          // Escribe la secuencia
    i++;                            // Incrementa el índice
    if (i >= No_Secuencias) i=0;    // Es la última secuencia?
    contador =0;                    // Reinicia contador de retardo
    }
}
/* END Events */

/*
________________________________________________________________________________
+
+   Funciones Prototipo
+_______________________________________________________________________________
*/

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
  Barrido.attach_us(&Barrido_OnInterrupt,Ticker_Rate);   // Periodo de interrupción de 1 ms (Ticker_Rate=1000)
    while (true) 
    {
                                //El Programa principal no hace nada !!!
    }
}
