/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_SquashedRaiders
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto es un video juego. El objetivo es eliminar aplastando
**         a cada ladrón que aparece en pantalla, mediante la flecha que aparece
**         en la pantalla lcd. Esto se logra presionando el botón de la tarjeta.
**         This module contains user's application code.
**   Componentes     : NewTextLCD, GPIO, ect.
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added lcd Menu, Beta version (with bugs)
**
* ###########################################################################/

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "NewTextLCD.h" 
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on  0
#define off 1
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalIn   push(SW1,PullUp);           // Botón Derecho (SW1)
DigitalOut  led_monitor(LED1);          // Inicializa el LED Monitor
Serial      terminal(USBTX, USBRX);     // Inicializa la Comunicación Serial a la PC
// I2C Communication
//I2C         lcd(PTC2,PTC1);             // SDA, SCL
// SPI Communication
//SPI         lcd(PTD6,PTD7,PTD5,PTD4);   // MOSI, MISO, SCLK, SSEL
// LCD instantiation 
//TextLCD_SPI lcd(&lcd, PTD4, Textlcd::lcd16x4, TextLCD::HD44780);    // SPI bus, SN74595 expander, CS pin, lcd Type 
//TextLCD_I2C lcd(&i2c_LCD, 0x7E, TextLCD::LCD20x4);                  // I2C bus, PCF8574A Arduino Shield, LCD Type
TextLCD lcd(PTA1,PTA2,PTD3,PTA12,PTA4,PTA5,TextLCD::LCD20x4);       // HD44780: R/S, E, DB4, DB5, DB6, DB7 

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
int pattern[8];
int pattern1[8];
int pattern2[8];

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
                // Las Definiciones de Funciones Prototipo 
                // y Apuntadores a Vectores de Interrupciones van aquí !
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
                // Definición del Primer Patrón
    pattern[0] = 0x0e;      //  0b00001110     ***
    pattern[1] = 0x0a;      //  0b00001010     * *
    pattern[2] = 0x0e;      //  0b00001110     *** 
    pattern[3] = 0x04;      //  0b00000100      * 
    pattern[4] = 0x1f;      //  0b00011111    *****     
    pattern[5] = 0x04;      //  0b00000100      * 
    pattern[6] = 0x0a;      //  0b00000100     * * 
    pattern[7] = 0x0a;      //  0b00000100     * *
                // Definición del Segundo Patrón   
    pattern1[0] = 0x0e;     //  0b00001110     ***
    pattern1[1] = 0x0a;     //  0b00001010     * *
    pattern1[2] = 0x0e;     //  0b00001110     ***
    pattern1[3] = 0x15;     //  0b00010101    * * *
    pattern1[4] = 0x0e;     //  0b00001110     ***
    pattern1[5] = 0x04;     //  0b00000100      * 
    pattern1[6] = 0x0a;     //  0b00001010     * *
    pattern1[7] = 0x11;     //  0b00010001    *   *
                // Definición del Tercer Patrón
    pattern2[0] = 0x04;     //  0b00000100      *
    pattern2[1] = 0x0e;     //  0b00001110     ***
    pattern2[2] = 0x1f;     //  0b00001111    *****
    pattern2[3] = 0x04;     //  0b00000100      *
    pattern2[4] = 0x04;     //  0b00000100      *
    pattern2[5] = 0x04;     //  0b00000100      *
    pattern2[6] = 0x04;     //  0b00000100      * 
    pattern2[7] = 0x0e;     //  0b00001110     ***  

terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

/* Configufración del Display lcd */    /* Mucho OjO !!! */
/* lcd Utilizando el SPI */   
//  lcd.frequency(100000);      // Frecuencia de operación para el SPI
//  lcd.format(8,0);            // Modo de Operación para el SPI

                // Inicialización de los patrones en la CGRAM
    lcd.writeCGRAM(0, pattern);
    lcd.writeCGRAM(1, pattern1);
    lcd.writeCGRAM(2, pattern2);
    /*Las líneas anteriores permiten realizar las figuras
    para el juego, como la flecha y los movimientos de
    los ladrones*/
INICIO:
    int i=0,j=0,y=0,p=0;
    uint16_t time=15;           // tiempo en ms
    while(push==1)              // Si no se oprime el Botón
    {
        if(i==9||i==19)y++;
        if(i==29)
        {
            y++;
            i=0;
        }
        if(j==20)j=0,y=0;
        p=y%2;
        lcd.locate(2,1);
        lcd.putc(p);
        lcd.locate(17,1);
        lcd.putc(p);
        lcd.locate(4,1);
        lcd.printf("Get all the\n      raiders!");
        wait_ms(time);
        i++;
        lcd.cls();
    }
    lcd.cls();
    lcd.locate(7,1);
    lcd.printf("INICIO!");
    wait(1);
    lcd.cls();                          // Limpia laPantalla LCD
    uint8_t atrapados=0,fallos=0,faltan=7;
    //Se muestran textos que dan indicaciones del juego.
    i=0;
   while(true){
    //***Siempre en pantalla*****
        lcd.locate(0,0);                // Inicio del LCD 
        lcd.printf("Missing %i    Fails %i",faltan,fallos);
        lcd.locate(9,1);
        lcd.printf(">%i",atrapados);
    /*Se añaden contadores para administrar el número de 
    ladrones por atrapar y los fallos cometidos por el usuario.*/
    //*******Ladrón desplazándose******
        if(i==2||i==5)y++;
        if(i==8){
            j++;
            y++;
            i=0;
        }
        if(j==20)j=0,y=0;
        p=y%2;
        lcd.locate(j,2);
        lcd.putc(p);
        wait_ms(time);
        i++;
        lcd.cls();
    //***Capturando al ladrón***
        if(j>=5&&j<=13)time=6;
        else time=15;
        
        if(push==0)           // Si se oprime el Botón
        {
            lcd.locate(11,2);
            lcd.putc(2);
            led_monitor=on;
            wait_ms(500);
            led_monitor=off;
            if(j==11)
            {
                faltan--;
                atrapados++;
                lcd.cls();
                lcd.locate(8,1);
                lcd.printf("BIEN!");
                j=0;
                i=0;
                wait(1);
            }
            else
            {
                lcd.cls();
                lcd.locate(6,1);
                lcd.printf("FALLASTE!");
                fallos++;
                j=0;
                i=0;
                wait(1);
            }
        }
        else
        {
            lcd.locate(11,3);
            lcd.putc(2);
        }
        if(j==19)
        {
            lcd.cls();
            lcd.locate(6,1);
            lcd.printf("FALLASTE!");
            fallos++;
            j=0;
            i=0;
            wait(1);
        }
        if(fallos==3)
        {
            lcd.locate(4,1);
            lcd.printf("Perdiste xD :(");
            wait(2);
            goto INICIO;
        }
        if(atrapados==7)
        {
            lcd.locate(4,1);
            lcd.printf("Ganaste! :D");
            wait(2);
            goto INICIO;
        }
        
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
                
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !

/* END functions */  

/* END Program */

/*+-----------------------------------------------------------------------------
*+                 Conexiones al LCD
*+
*+ FRDM-KL46Z                PTA1,    PTA2, PTD3,PTA12,PTA4,PTA5  PWM   
*+              GND Vcc POT       GND                                  GND
*+ HD44780:     GNG Vcc Vee  R/S  RW   E    DB4   DB5  DB6  DB7   BL+  BL-    
*+
*+------------------------------------------------------------------------------       
*+ Direccinamiento de la RAM del Display:
*+ 
*+ Los módulos de 8x1 (obsoletos) están arreglados como una líneas de 
*+ 8 caracteres de lada a lado.
*+  "Linea 1" Las direcciones comienzan en 80h a 87h
*+
*+ Los módulos de 16x1 están arreglados como dos líneas de 8 caracteres de lada a lado.
*+  "Linea 1" Las direcciones comienzan en 80h a 87h (primera parte de la línea)
*+  "Linea 1" Las direcciones comienzan en C0h a C7h (segunda parte de la línea)
*+  de manera que al escribir caracteres al módulo, el cursor se incrementará automaticamente
*+  hasta alcanzar el 9° caracter entonces tendrá que mover el cursor a la dirección C0h antes
*+  de escribir el 9° caracter en el módulo de 1x16.
*+  
*+  Módulo de 16x2 es dos líneas por 16 caracteres
*+  "Linea 1" Las direcciones comienzan en 80h a 8Fh
*+  "Linea 2" Las direcciones comienzan en C0h a CFh
*+
*+  Módulo de 16x4 
*+  "Linea 1" Las direcciones comienzan en 80h a 8Fh
*+  "Linea 2" Las direcciones comienzan en C0h a CFh
*+  "Linea 3" Las direcciones comienzan en 90h a 9Fh
*+  "Linea 4" Las direcciones comienzan en D0h a DFh
*+    
*+  Módulo de 20x1 
*+  "Linea 1" Las direcciones comienzan en 80h a 93h
*+  
*+  Módulo de 20x2 
*+  "Linea 1" Las direcciones comienzan en 80h a 93h
*+  "Linea 2" Las direcciones comienzan en C0h a D3h
*+  
*+  Módulo de 20x4 
*+  "Linea 1" Las direcciones comienzan en 80h a 93h
*+  "Linea 2" Las direcciones comienzan en C0h a D3h
*+  "Linea 3" Las direcciones comienzan en 94h a A7h
*+  "Linea 4" Las direcciones comienzan en D4h a E7h
*+  
*+  Módulo de 24x2 
*+  "Linea 1" Las direcciones comienzan en 80h a 98h
*+  "Linea 2" Las direcciones comienzan en C0h a D8h
*+  
*+  Módulo de 32x2 
*+  "Linea 1" Las direcciones comienzan en 80h a A0h
*+  "Linea 2" Las direcciones comienzan en C0h a E0h
*+
*+  Módulo de 40x2 
*+  "Linea 1" Las direcciones comienzan en 80h a A7h
*+  "Linea 2" Las direcciones comienzna en C0h a E7h
*+ 
*+
*+--------------------------------------------------------------------------- */ 

/*+-----------------------------------------------------------------------------
*+ Inicializaci¢n del Display de Cristal Líquido Alfanumérico en modo de 4 bits
*+
*+ Definici¢n de pines:
*+                            __      Vdd GND
*+             MOSI MISO SCK SS       |   |    
*+               |   |   |   |       10K  |   
*+               |   |   |   |        |   |    
*+ CD 4094     DATA NC CLOCK STROBE  NC  OE  QS  ---> DATA en la siguiente etapa
*+ 74HC 595     SER NC SCLK RCLK    SCLR  G  QH' ---> SER en la siguiente etapa
*+
*+ CD 4094      Q1  Q2  Q3  Q4   Q5  Q6  Q7  Q8
*+ 74HC 595     QA  QB  QC  QD   QE  QF  QG  QH
*+               |   |   |   |    |   |   |   |
*+               |   |   |   |    |   |   |   |               
*+ HD44780      R/S  RW  E  BL   DB4 DB5 DB6 DB7 
*+
*+ Notas: El pin RW del LCD debe estar estar siempre en "L" o conectado a GND.
*+        El pin E2 es usado solo para el LCD40x4 (segundo controlador)
*+        La señal BL = LED+ y debe ser usado para control del Backlight
*+        Para enviar cualquier dato o instrucci¢n hay que hacer una   _
*+        transici¢n de bajo a alto en el pin de E (Enable) del LCD. _| |_
*+
*+------------------------------------------------------------------------------
*+
*+ Ubicaciónn de pines:
*+      ---------------------------------------------------------------------
*+      |  _______________________________________________________________  |
*+      | |                                                               | |
*+      | |                                                               | |
*+      | |                                                               | |
*+      | |                                                               | |
*+      | |                                                               | |
*+      | |                                                               | |
*+      | |_______________________________________________________________| |
*+      |                                                                   |
*+      ---------------------------------------------------------------------
*+                          |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |
*+                          |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |
*+                          16 15 14 13 12 11 10 9  8  7  6  5  4  3  2  1
*+
*+   1   Vss - GND
*+   2   Vdd - Vcc
*+   3   Vee - Ajuste de contraste
*+   4   RS  - (Register/String) 0=Entrada de Instrucción, 1=Entrada de Dato 
*+   5   RW  - Lectura/Escritura 0=Escribe al LCD, 1=Lee del LCD
*+   6   E   - Señal de Habilitación  "101"
*+   7   DB0 - Línea 0 del bus de datos
*+   8   DB1 - Línea 1 del bus de datos
*+   9   DB2 - Línea 2 del bus de datos
*+   10  DB3 - Línea 3 del bus de datos  _
*+   11  DB4 - Línea 4 del bus de datos   |
*+   12  DB5 - Línea 5 del bus de datos    \  Operación en 4 bits
*+   13  DB6 - Línea 6 del bus de datos    / 
*+   14  DB7 - Línea 7 del bus de datos  _|
*+   15  LED+  Ánodo  Backlight
*+   16  LED-  Cátodo Backlight 
*+
*+------------------------------------------------------------------------------                                 
*+
*+  +5V ------------*----------- Vcc          PTE19 PTE18 PTE20 PTE21 PTE22 PTE23                
*+                  |                           RS    E    D4    D5    D6    D7 
*+                  /
*+          10k to  \<---------- Vee          R/W ---> GND  
*+          20k pot /                         A   ---> PWM1 o   R=330 ---> Vcc
*+                  \                         K   ---> GND
*+                  |
*+  GND ------------*----------- Vss
*+
*+------------------------------------------------------------------------------
*+      
*+ Definici¢n de bits:
*+
*+ I/D=1:   (Increment/Decrement) Incremento (+) del Cursor
*+ I/D=0:   (Increment/Decrement) Decremento (-) del Cursor
*+ D=0:     (Display) Apaga el Display
*+ D=1:     (Display) Enciende el Display
*+ C=0:     (Cursor) Apaga el Cursor
*+ C=1:     (Cursor) Enciende el Cursor
*+ B=0:     (Blinking) Apaga el parpadeo del Cursor
*+ B=1:     (Blinking) Enciende el parpadeo del Cursor
*+ S=0:     (Shift) Sin corrimiento del Display
*+ S=1:     (Shift) Con corrimiento del Display
*+ S/C=1:   (Shift/Cursor) Con corrimiento del Display
*+ S/C=0:   (Shift/Cursor) Con Movimiento del Cursor
*+ R/L=1:   (Right/Left) Corrimiento a la Derecha
*+ R/L=0:   (Right/Left) Corrimiento a la Izquierda
*+ DL=1:    (Data Lenght) 8 Bits de datos
*+ DL=0:    (Data Lenght) 4 Bits de datos
*+ N=1:     (Number Lines) Modo de 2 Líneas de despliege
*+ N=0:     (Number Lines) Modo de 1 Línea de despliege
*+ F=1:     (Font) 5X10 Puntos por caracter
*+ F=0:     (Font) 5X7 Puntos por caracter
*+ BF=1:    (Busy Flag) Operación interna en proceso
*+ BF=0:    (Busy Flag) Listo para aceptar instrucciones/datos
*+ DDRAM:   (Display Data Ram)
*+ CGRAM:   (Character Generator RAM)
*+ ACC:     Address of CGRAM
*+ ADD:     Address of DDRAM These correspond to curser addresses.
*+ AC:      Address counter used for both DDRAM and CGRAM
*+
*+                              RS RW  MSB                         LSB 
*+ Clear Display                0  0    0   0   0   0   0   0   0   1
*+ Cursor at Home               0  0    0   0   0   0   0   0   1   0
*+ Entry Mode Set               0  0    0   0   0   0   0   1  I/D  S
*+ Display ON/OFF control       0  0    0   0   0   0   1   D   C   B
*+ Cursor/Display Shift         0  0    0   0   0   1  S/C R/L  x   x
*+ Function Set                 0  0    0   0   1   DL  N   F   x   x
*+ CGRAM                        0  0    0   1   -------- ACC --------
*+ DDRAM                        0  0    1   ---------- ADD ----------
*+ Busy Flag/Address Read       0  1    1   -----------AC------------
*+ CGRAM/CDDRAM Data Write      1  0            Write Data
*+ CGRAM/CDDRAM Data Read       1  1            Read  Data
*+
*+
*+ Tiempos de Ejecución:
*+ Dependiendo del Oscilador Interno del LCD los tiempos de ejecución de las 
*+ instrucciones pueden variar.
*+                                          Fosc
*+   INSTRUCCION            160Khz          250Khz          270Khz
*+   Clear Display          120us~4.9ms     82us~1.6ms      40us~1.5ms
*+   Cursor Home            120us           40~1.6ms        37us~1.5ms
*+   Todas las demás        120us           40us            37us
*+   Lectura/Escritura      120us           40us            37us
*+   Lectura de Busy Flag   1us             1us             1us

*+   El controlador podría estar en modo de 8 bits (reinicio de encendido)
*+   o en modo de 4 bits (reinicio en caliente) en este punto.
*+   Siga este procedimiento para asegurarse de que el controlador entre en el
*+   estado correcto. 
*+
*+******************************************************************************
*+// Patrón de Configuración del LCD  en modo de 4 bits (LSN first)
*+******************************************************************************
*+   char init_LCD[] = {0b00000000, 0b00000000, // Datos en DB7=DB6=DB5=DB4=0, LED+=0, EN=0,RW=0,RS=0   
*+                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0
*+                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0
*+                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0 
*+                      0b00101110, 0b00100010, // Datos en DB5=1, LED+=1, EN=1,0,RW=1,RS=0                       
*+                      0b00101110, 0b00100010, // => Function Set Control: DB5=1, LED+=1, EN=1,0,RW=1,RS=0 
*+                      0b10001110, 0b10001110, // => Function Set Control: DB7=N=1 2 líneas, DB6=F=0 5x7puntos, LED+=1, EN=1,0,RW=1,RS=0
*+                      0b00001110, 0b00000010, // => Display ON/OFF Control: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0 
*+                      0b00101110, 0b00100010, // => Display ON/OFF Control: DB7=1 (Display off, cursor off, blink off),LED+=1, EN=1,0,RW=1,RS=0
*+                      0b00001110, 0b00000010, // => Display Clear: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0 
*+                      0b00011110, 0b00010010, // => Display Clear: D4=1, LED+=1, EN=1,0,RW=1,RS=0
*+                      0b00001110, 0b00000010, // => Cursor Home: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0                                          
*+                      0b00101110, 0b00100010, // => Cursor Home: DB5=1, LED+=1, EN=1,0,RW=1,RS=0 , (Cursor Home};
*+                      0b01001111, 0b00001011, // => Text 0x48: DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
*+                      0b10001111, 0b00101011, // => Text "H" : DB7=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "H"}
*+                      0b01101111, 0b01101011, // => Text 0x6F: DB5=1, LED+=1, EN=1,0,RW=1,RS=1
*+                      0b11111111, 0b11111011, // => Text "o" : DB7=DB6=DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "o"}
*+                      0b01101111, 0b01101011, // => Text 0x6C: DB6=DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
*+                      0b11001111, 0b11001011, // => Text "l" : DB7=DB6=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "l"}
*+                      0b01101111, 0b01101011, // => Text 0x61: DB6=DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
*+                      0b00011111, 0b00011011, // => Text "a" : DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "a"}
*+                      0b00101111, 0b00101011, // => Text 0x21: DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
*+                      0b00011111, 0b00011011};// => Text "!" : DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "!"}
*+
*+   La interfaz de hardware entre el MCU y la LCD  en modo de 8 bits solo puede 
*+   recibir los 4 bits más significativos (Nibble más significativo, MSN) 
*+   como instrucción para cambier a modo 4.
*+   En el modo de 4 bits, la pantalla LCD espera el MSN primero, seguido del LSN.
*+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END Mbed */ 