/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Pasos
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**      El programa genera las diferentes secuencias para operar un motor a pasos 
**      (Stepper Motor).
**      Este programa tiene 3 modos de operación:
**          1) Medio Paso
**          2) Pasos Completo
**          3) Pasos Wave
**      Además puede girar en el sentido horario o anti horario
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "MKL46Z4.h"
#include "stdio.h"
#include "string.h"
#include "TSISensor.h"      // Libreria para Touch Sensor Interface
#include "TextLCD.h"        // Libreria para escritura en LCD 
#include "I2C.h"            // Libreria para la interface I2C
#include "SPI.h"            // Libreria para la interface SPI
#include "Serial.h"         // Libreria para la interface Serial
#include "MMA8451Q.h"       // Libreria para el Acelerómetro

#include "stdio.h" 
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define   MMA8451_I2C_ADDRESS (0x1d<<1) // Dirección del Acelerómetro

#define   Modo_Wave             3 
#define   Paso_Doble            2
#define   Paso_Completo         1 
#define   Medio_Paso            0 
#define   Sentido_Horario       1 
#define   Sentido_Antihorario   0 
#define   On                    0
#define   Off                   1
#define   TRUE                  1
#define   FALSE                 0
#define   DO2                   0.0078125            // 128 Hz
#define   DOs2                  0.0073740180703125   // 136 Hz
#define   RE2                   0.006960146234375    // 144 Hz
#define   REs2                  0.0065695032421875   // 152 Hz
#define   MI2                   0.006200785359375    // 161 Hz
#define   FA2                   0.005852762015625    // 171 Hz
#define   FAs2                  0.0055242717265625   // 181 Hz
#define   SOL2                  0.0052142181796875   // 192 Hz
#define   SOLs2                 0.0049215666015625   // 203 Hz
#define   LA2                   0.004645340296875    // 215 Hz
#define   LAs2                  0.004384617375       // 228 Hz
#define   SI2                   0.0041385277109375   // 242 Hz
#define   DO3                   0.00390625           // 256 Hz
#define   DOs3                  0.00368700903515625  // 271 Hz
#define   RE3                   0.0034800731171875   // 287 Hz
#define   REs3                  0.00328475162109375  // 304 Hz
#define   MI3                   0.0031003926796875   // 323 Hz
#define   FA3                   0.0029263810078125   // 342 Hz
#define   FAs3                  0.0055242717265625   // 362 Hz
#define   SOL3                  0.00260710908984375  // 384 Hz
#define   SOLs3                 0.00246078330078125  // 406 Hz
#define   LA3                   0.0023226701484375   // 431 Hz
#define   LAs3                  0.0021923086875      // 456 Hz
#define   SI3                   0.00206926385546875  // 483 Hz
#define   DO4                   0.00390625           // 512 Hz
#define   DOs4                  0.001843504517578125 // 542 Hz
#define   RE4                   0.00174003655859375  // 575 Hz
#define   REs4                  0.001642375810546875 // 609 Hz
#define   MI4                   0.00155019633984375  // 645 Hz
#define   FA4                   0.00146319050390625  // 683 Hz
#define   FAs4                  0.001381067931640625 // 724 Hz
#define   SOL4                  0.001303554544921875 // 767 Hz
#define   SOLs4                 0.001230391650390625 // 813 Hz
#define   LA4                   0.00116133507421875  // 861 Hz
#define   LAs4                  0.00109615434375     // 912 Hz
#define   SI4                   0.001034631927734375 // 966 Hz
#define   DO5                   0.001953125          // 1024 Hz
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker     Barrido;                     // Interrupción del Timer
BusOut     Salidas(PTE19, PTE18, PTE17, PTE16); // Salidas a las bobinas:  A  /A   B  /B
DigitalOut Led_Azul  (PTE2);            // Definición para el Led Azul
DigitalOut Led_Verde (PTE3);            // Definición para el Led Verde
DigitalOut Led_Rojo  (PTE6);            // Definición para el Led Rojo
DigitalOut Green_Led (PTD5);            // Led de Actividad del Programa
DigitalOut Red_Led   (PTE29);           // Led de Actividad del Programa
DigitalIn  Adelante  (PTC3, PullUp);    // Switch para mover hacia Adelante
DigitalIn  Atras     (PTC12,PullUp);    // Switch para mover hacia Atras     
BusIn      Modo      (PTB18,PTB19);     // Modo de operación de los motores
PwmOut     Backlight (PTD2);            // Activacion Backlight del LCD
PwmOut     Buzzer    (PTE31);           // Salida del Buzzer

/*
** -------------------------------------------------------------------
**    Inicialización de los Pines de Funciones Especiales.
** -------------------------------------------------------------------
*/
TSISensor  tsi;                         //activa el Touch Sensor Interface

// Host PC Communication channels
Serial      terminal(USBTX, USBRX);     // USB Terminal Interface Tx, Rx
//Serial    terminal(PTA2,PTA1);        // Terminal Serial
//Serial    terminal(PTE0, PTE1);       // Tx, Rx Using MAX3232 or BlueTooth
//Serial    terminal(PTE22, PTE23);
// -------- Bluetooth Communication support --------
Serial      bluetooth(PTE0, PTE1);      // Tx, Rx

/************************************************* 
* Inicializa la biblioteca TextLCD con los números de los pines de la interface
* Board Freedom FRDM-KL25Z
* IDE  Mbed On Line Compiler
* LCD  SPI  SN74595
* Pin  Board     LCD
*      SPI_MOSI  SER   (white) 
*      SPI_MISO  none  (blue)  
*      SPI_CLK   SRCLK
*      SPI_PCS   RCLK
*      5V       5V  (red)
*      GND      GND (black)
* LCD  I2C  PCF8574A
* Pin  Board    LCD
*      I2C_SCL  SCL (white) + resistance pull-up 4.7k
*      I2C_SDA  SDA (blue)  + resistance pull-up 4.7k
*      5V       5V  (red)
*      GND      GND (black)
* LCD  Port PTE
* LCD  Port PTC
***************************************************/
// -------- I2C Communication ---------
//I2C         i2c_LCD(PTC2,PTC1);             // SDA, SCL

// -------- SPI Communication ---------
//SPI         spi_LCD(PTD6,PTD7,PTD5,PTD4);   // MOSI, MISO, SCLK, SSEL

//--------- LCD instantiation -----------
//TextLCD_SPI lcd(&spi_LCD, PTD4, TextLCD::LCD16x4, TextLCD::HD44780);  // SPI bus, SN74595 expander, CS pin, LCD Type 
//TextLCD_I2C lcd(&i2c_LCD, 0x7E, TextLCD::LCD20x4);                    // I2C bus, PCF8574A Arduino Shield, LCD Type
TextLCD     lcd(PTC6, PTC7, PTC8, PTC9, PTC10, PTC11, TextLCD::LCD20x4); // 4bit bus: rs, e, d4-d7
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint8_t  paso;
uint8_t  No_Pasos;
uint8_t  Revoluciones;
uint8_t  Sentido;
uint8_t  modo_paso;
uint16_t Velocidad=50000;
char     Cadena[20];
char     Modo_0[]="Medio Paso\n\r";
char     Modo_1[]="Paso Completo\n\r";
char     Modo_2[]="Medio Paso\n\r";
char     Modo_3[]="Modo Wave\n\r";
char     Modo_4[]="Antihorario \n\r";
char     Modo_5[]="Horario \n\r";
uint8_t  Unipolar[8]      = {0x01,0x03,0x02,0x06,
                             0x04,0x0C,0x08,0x09} ;     // Unipolar
uint8_t  Bipolar[4]       = {0x05,0x09,0x0A,0x06} ;     // BiPolar
uint8_t  Wave_Drive[4]    = {0x01,0x02,0x04,0x08} ;     // Modo Onda 
uint8_t  Modo_Completo[4] = {0x03,0x06,0x0C,0x09} ;     // Paso Doble
bool     Flag;
uint8_t  dummy;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);              // Rutina de Atención al Ticker
void Buzzer_SetPeriodMode(float Periodo,bool Estado);
void outstrg(char *ap_cad);
void Despliega_L1(char *ap_cad);
void Despliega_L2(char *ap_cad); 
void Despliega_L3(char *ap_cad); 
void Despliega_L4(char *ap_cad);
 
/* END Events */        // Rutinas de Atención a Interrupciones


/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main() {
  /* Write your code here */
  Barrido.attach_us(&Barrido_OnInterrupt, Velocidad);   // Le asigna el periodo de barrido cada 10 ms
  No_Pasos=0,paso=0,modo_paso=Medio_Paso;   // Configuración de Arranque del Motor
  Red_Led   = Off;                          //Apaga Led's de los botones
  Green_Led = Off;     
  terminal.baud(115200);                    //velocidad de transmisión para la terminal serial
  /* Configufración del Display LCD */      /* Mucho OjO !!! */
//  spi_LCD.frequency(100000);      // Frecuencia de operación para el SPI (100KHz)
//  spi_LCD.format(8,0);            // Modo de Operación para el SPI
//  i2c_LCD.frequency(100000);      // Frecuencia de operación para el I2C (100KHz)
//  i2c_LCD.start();                // Inicio de operación para el I2C
  lcd.printf("  MOTOR A PASOS");    //mensaje a desplegar en el LCD
  terminal.printf("  MOTOR A PASOS\n\r\n");   
  Buzzer=Off;                       // Apaga el Buzzer
  Flag=TRUE;                        // Enciende la bandera
  while(1) 
  {
  if (Flag==TRUE)
    {
     outstrg ("MODO DEL MOTOR A PASOS: ");
       if (modo_paso==Modo_Wave)        strcpy (Cadena,Modo_3);
       if (modo_paso==Paso_Doble)       strcpy (Cadena,Modo_2);
       if (modo_paso==Paso_Completo)    strcpy (Cadena,Modo_1);  
       if (modo_paso==Medio_Paso)       strcpy (Cadena,Modo_0);         
     outstrg (Cadena);
     outstrg ("SENTIDO DEL MOTOR: ");
       if (Sentido==Sentido_Antihorario) strcpy (Cadena, Modo_4);
       if (Sentido==Sentido_Horario)     strcpy (Cadena, Modo_5);   
     outstrg (Cadena);
     dummy=sprintf(Cadena,"Paso:      %3d  \n\r",paso); 
     Despliega_L2 (Cadena);
     outstrg (Cadena);   
     dummy=sprintf(Cadena,"No. Pasos: %3d  \n\r",No_Pasos); 
     Despliega_L3 (Cadena);
     outstrg (Cadena);  
     dummy=sprintf(Cadena,"Vueltas: %3d  \n\r",Revoluciones); 
     Despliega_L4 (Cadena);
     outstrg (Cadena);
//     outstrg (Cadena);     
     Flag=FALSE ; 
//     if (tsi.readPercentage()!=0.0) Backlight = 1.0-tsi.readPercentage(); // Lee el TSI y cambia el Backlight del LCD
     if (tsi.readPercentage()!=0.0) Velocidad = (1.0-tsi.readPercentage())*65535; // Lee el TSI y cambia la velocidad del motor
     wait(0.1);
   
    }       // End Flag
  }         // End While
}           // End Main 
/* END Pasos */
/* END main() */
/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupcion van aquí !

void Barrido_OnInterrupt(void)              // Rutina de Atención al Ticker
{
//    if (paso>8)paso=0;
//    Buzzer_SetPeriodMode(LA4,FALSE);      // Apaga el Buzzer
    modo_paso=Modo;
  if (Flag==FALSE)
  {
    if (Atras==FALSE)                       // Se presionó el Botón Izquierdo?
    {
      Red_Led=On;
      Sentido=Sentido_Antihorario;
      if (modo_paso==Modo_Wave)             // Modo: WAVE DRIVE
       {
         Buzzer_SetPeriodMode(DO2,TRUE);
         Buzzer=On;                         // Enciende el Buzzer
         if (paso==0) paso=3;
             else paso-- ;
             Salidas=Wave_Drive[paso];
             
       }
      if (modo_paso==Paso_Completo)            // Modo: FULL STEP
       {
        Buzzer_SetPeriodMode(MI2,TRUE);
        Buzzer=On;                          // Enciende el Buzzer
        if (paso==0) paso=6;
            else 
            {
             paso--; 
             paso--;                  
            }
            Salidas=(Unipolar [paso]);           
       }
      if (modo_paso==Medio_Paso)            // Modo: HALF STEP
       {
        Buzzer_SetPeriodMode(SOL2,TRUE);
        Buzzer=On;                          // Enciende el Buzzer
        if (paso==0) paso=7;
            else paso-- ;
            Salidas=(Unipolar [paso]);  
       }
      if (modo_paso==Paso_Doble)             // Modo: DOUBLE STEP
       {
         Buzzer_SetPeriodMode(LAs2,TRUE);
         Buzzer=On;                         // Enciende el Buzzer
         if (paso==0) paso=3;
             else paso-- ;
             Salidas=Bipolar[paso];
             
       } 
      No_Pasos-- ;
      Red_Led = Off;                        // Apaga Led's de los botones   
    }
    Flag=TRUE;
  if (Adelante==FALSE)                       // Se presionó el Botón Derecho?
    {
     Green_Led=On;
     Sentido=Sentido_Horario;
     if (modo_paso==Modo_Wave)              // Modo: WAVE DRIVE
       {
         Buzzer_SetPeriodMode(DO3,TRUE); 
         Buzzer=On;                         // Enciende el Buzzer
         if (paso==3) paso=0;
             else paso++ ;
             Salidas=(Wave_Drive [paso]);    
       }
     if (modo_paso==Paso_Completo)          // Modo: FULL STEP
       {
        Buzzer_SetPeriodMode(MI3,TRUE);
        Buzzer=On;                         // Enciende el Buzzer
        if (paso==6) paso=0;
            else 
             {
              paso++; 
              paso++;
             }
            Salidas=(Unipolar [paso]);               
       }
     if (modo_paso==Medio_Paso)             // Modo: HALF STEP
       {
        Buzzer_SetPeriodMode(SOL3,TRUE);
        Buzzer=On;                          // Enciende el Buzzer
        if (paso==7) paso=0;
            else paso++ ;
            Salidas=(Unipolar [paso]);      
       }   
      if (modo_paso==Paso_Doble)             // Modo: DOUBLE STEP
       {
         Buzzer_SetPeriodMode(LAs3,TRUE);
         Buzzer=On;                         // Enciende el Buzzer
         if (paso==3) paso=0;
             else paso++ ;
             Salidas=Bipolar[paso];
             
       }        
      No_Pasos++ ;     
    } 
      //Flag=TRUE;
      Green_Led = Off;                      //Apaga Led's de los botones    
  }
     if (No_Pasos==180)  Revoluciones++;  
   Flag=TRUE ;  
}
/* END Events */

/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
                
void Buzzer_SetPeriodMode(float Periodo,bool Estado)
{
    Buzzer.period(Periodo);
    Buzzer.pulsewidth(Periodo/2);
    if (Estado==1)Buzzer=0.5; 
    if (Estado==0)Buzzer=0.0; 
}


void outstrg(char *ap_cad) 
{  
  while(*ap_cad)
  {  
   while(!terminal.writeable()); 
   terminal.putc(*ap_cad++);
   printf("%s",*ap_cad);
  }
}

void Despliega_L1(char *ap_cad) 
{
    lcd.locate(0,1);            //Coloca cursor de la LCD al inicio de la Linea 1.
    lcd.printf("", *ap_cad);    //Imprime mensaje en la LCD.
}
void Despliega_L2(char *ap_cad) 
{
    lcd.locate(0,2);            //Coloca cursor de la LCD al inicio de la Linea 2.
    lcd.printf("", *ap_cad);    //Imprime mensaje en la LCD.
}
void Despliega_L3(char *ap_cad) 
{
    lcd.locate(0,3);            //Coloca cursor de la LCD al inicio de la Linea 3.
    lcd.printf("", *ap_cad);    //Imprime mensaje en la LCD.
}
void Despliega_L4(char *ap_cad) 
{
    lcd.locate(0,4);            //Coloca cursor de la LCD al inicio de la Linea 4.
    lcd.printf("", *ap_cad);    //Imprime mensaje en la LCD.
}
/* END Routines */ 

/* END program */ 

/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Habilitar el módulo TSI para cambiar la velocidad del motor.
| 2.-   Habilitar el programa para que despligue los datos en la pantalla LCD: 
|       
+-------------------------------------------------------------------------------
|                               EXAMEN
|
| 1.-   Modificar el programa para que envie datos y se pueda modificar a traves 
|       del teléfono celular por medio de la interface Bluetooth.
| Suerte!
+-------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */