/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_PWM-8_TSI_SLCD
**    Procesador     : MKL46Z256VLL4
**    Tarjeta        : FDRM-KL46Z
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Fecha/Hora     : 27-05-2019, 15:18, # CodeGen: 0
**    Descripción    :
**         Este proyecto realiza el control de 8 salidas PWM para su aplicación 
**         en la iluminación de una barra de LED's controaldo su intensidad
**         individualmente mediante el TSI
**   Componentes     : PWM(D0-D7), DisplayLCD, TSI, GPIO
**   Autores         : Monserrat Gutierrez Aranda
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "SLCD.h"
#include "tsi_sensor.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
// Very simple program to read the analog slider and print its value
// on the LCD. Also flashes the RED led.
// -- Al Williams

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
//Configuración Terminal Serial
Serial      terminal(USBTX,USBRX); // OjO USBTX = PTA2, USBRX = PTA1
//Configuración TSI Analógico
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
//Configuración LCD
SLCD        slcd; 
//Configuración de PWM's para control de luminocidad
/*
PwmOut      led1(PTC1);    // PTC1_TPM0_CH0
PwmOut      led2(PTA4);    // PTA4_TPM0_CH1
PwmOut      led3(PTA5);    // PTA5_TPM0_CH2
PwmOut      led4(PTA6);    // PTA6_TPM0_CH3
PwmOut      led5(PTA7);    // PTA7_TPM0_CH4
PwmOut      led6(PTD5);    // PTD5_TPM0_CH5
PwmOut      led7(PTA12);   // PTA12_TPM1_CH0
PwmOut      led8(PTA13);   // PTA13_TPM1_CH1
*/
PwmOut      led1(A5);    // PTC1_TPM0_CH0  
PwmOut      led2(A4);    // PTC2_TPM0_CH1
PwmOut      led3(D5);    // PTA5_TPM0_CH2  
PwmOut      led4(D2);    // PTD2_TPM0_CH3
PwmOut      led5(D6);    // PTD6_TPM0_CH4
PwmOut      led6(D7);    // PTC9_TPM0_CH5
PwmOut      led7(D3);    // PTA12_TPM1_CH0
PwmOut      led8(D8);    // PTA13_TPM1_CH1  

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
//Configuración de terminales de entrada
//DigitalIn   Push1(PTC12);    //
//DigitalIn   Push2(PTC3);     //
//Interrupciones externas
InterruptIn incrementa (SW1);      //
InterruptIn decrementa (SW3);      //
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
//LCD
char buffer[5];
//Selección de PWM
int menu = 0;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
//LCD
char Int2Char(int);
void Number2Buffer(int, int);
void imprimir(int, int);
//Interrupciones
void incrementaIRQ(void);
void decrementaIRQ(void);

/* END Definitions */  
////////////////////////////////////////////////////////////////////////////////
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
 //Se inicializa la Terminal Serial   
 terminal.baud(115200);  
 terminal.printf("8 PWM's controlados por TSI"); 
//Se inicializa el LCD 4x8            
    slcd.Home();
    slcd.printf("HOLA");
    wait(2.5);
    slcd.All_Segments(1);
    wait(0.5);
    slcd.All_Segments(0);
    wait(0.1); 
//Encendemos el punto 1 de la LCD
    slcd.DP1(1);
//Inicializamos interrupciones externas
    incrementa.mode(PullUp); 
    decrementa.mode(PullUp); 
    incrementa.fall(&incrementaIRQ);     //
    decrementa.fall(&decrementaIRQ);     //
//Se inicializan los PWM's
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    led5 = 0;
    led6 = 0;
    led7 = 0;
    led8 = 0;  
//Bucle infinito
    while (true) 
    {        
        switch(menu)
        {
            case 0:
                if(tsi.readPercentage()!=0){led1 = tsi.readPercentage();}
                imprimir(1,led1*100);
                terminal.printf("1,%d \r",led1*100 );
                break;
            case 1:
                if(tsi.readPercentage()!=0){led2 = tsi.readPercentage();}
                imprimir(2,led2*100);
                terminal.printf("2,%d \r",led2*100 );
                break;
            case 2:
                if(tsi.readPercentage()!=0){led3 = tsi.readPercentage();}
                imprimir(3,led3*100);
                terminal.printf("3,%d \r",led3*100 );
                break;
            case 3:
                if(tsi.readPercentage()!=0){led4 = tsi.readPercentage();}
                imprimir(4,led4*100);
                terminal.printf("4,%d \r",led4*100 );
                break;
            case 4:
                if(tsi.readPercentage()!=0){led5 = tsi.readPercentage();}
                imprimir(5,led5*100);
                terminal.printf("5,%d \r",led5*100 );
                break;
            case 5:
                if(tsi.readPercentage()!=0){led6 = tsi.readPercentage();}
                imprimir(6,led6*100);
                terminal.printf("6,%d \r",led6*100 );
                break;
            case 6:
                if(tsi.readPercentage()!=0){led7 = tsi.readPercentage();}
                imprimir(7,led7*100);
                terminal.printf("7,%d \r",led7*100 );
                break;
            case 7:
                if(tsi.readPercentage()!=0){led8 = tsi.readPercentage();}
                imprimir(8,led8*100);
                terminal.printf("8,%d \r",led8*100 );
                break;
            default:              
                break;
        }
        wait(0.1);
    }
}  

/* END main */
/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void incrementaIRQ()
{
    if(menu>=7){menu = 7;}
    else{menu++;}
}
void decrementaIRQ()
{
    if(menu<=0){menu = 0;}
    else{menu--;}
}

/* END Events */  
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
char Int2Char(int numero)
{
    return numero + '0';
}
void Number2Buffer(int display, int porcentaje)
{
    int centena = porcentaje/100;
    int decena  = (porcentaje-(centena*100))/10;
    int unidad  = porcentaje-centena*100-decena*10;
    buffer[0]= Int2Char(display);
    buffer[1]= Int2Char(centena);
    buffer[2]= Int2Char(decena);
    buffer[3]= Int2Char(unidad);
}
void imprimir(int display, int porcentaje)
{
    Number2Buffer(display,porcentaje);
    slcd.printf(buffer);
}

/* END Program */

/* END Mbed */ 