/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Led_RGB
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "Led_RGB.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define Ticker_Rate     1000            // Periodo en uSeg
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      TimerInt;                // Inicializa la Interrupción por Timer
// Definición de Led's para la FRDM-KL46Z
DigitalOut led_monitor(LED_GREEN);  // PTD5  LED1
DigitalOut led_testigo(LED_RED);    // PTE29 LED2
// Definición del Led RGB para la FRDM-KL46Z                                    
//DigitalOut  Led_Rojo (PTE2);        // PTE2   LED_ROJO
//DigitalOut  Led_Verde(PTE3);        // PTE3   LED_VERDE    
//DigitalOut  Led_Azul (PTE6);        // PTE6   LED_AZUL 
// Host PC Communication channels
Serial      terminal(USBTX, USBRX);         // Tx, Rx
//Serial      terminal(PTA2,PTA1);          // Terminal Serial
//Serial      terminal(PTE0, PTE1);         // Tx, Rx Using MAX3232 or BlueTooth
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
uint8_t  Seleccion;                 // Seleccion de opción para el menú
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void TimerInt_OnInterrupt(void);  
void Blinking_Led(void); 
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
                // Inicialización de variables, puertos e interrupciones
TimerInt.attach_us(&TimerInt_OnInterrupt, Rate);   // Le asigna el periodo de barrido de 1ms (Rate=1000)
terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
      printf("LED RGB \r\n\n");
    inicio:
     
      printf("Elija la Opcion Deseada: \r\n");
      printf("Que Color deseas?  \r\n\n");
      printf("1 Rojo     \r\n");
      printf("2 Verde    \r\n");
      printf("3 Ambar    \r\n");
      printf("4 Azul     \r\n");
      printf("5 Magenta  \r\n");
      printf("6 Turqueza \r\n");
      printf("7 Blanco   \r\n");
      printf("0 Apagado  \r\n\n");
      Blinking_Led();
    opcion:
      Seleccion=getchar();
      printf("Opcion selecionada: ");
      printf("%c \n\r",Seleccion );
      if (Seleccion >='8') 
          {
            printf("Seleccion equivocada!  \r\n");
            printf("Vuelve a intentarlo... \r\n\n");
            goto opcion;
          }
      switch (Seleccion)
      {
      case '1':printf("Color seleccionado:  ROJO     \r\n"); Color_RGB (RED);     break;     
      case '2':printf("Color seleccionado:  VERDE    \r\n"); Color_RGB (GREEN);   break;
      case '3':printf("Color seleccionado:  AMBAR    \r\n"); Color_RGB (AMBER);   break;      
      case '4':printf("Color seleccionado:  AZUL     \r\n"); Color_RGB (BLUE);    break;
      case '5':printf("Color seleccionado:  MAGENTA  \r\n"); Color_RGB (MAGENTA); break;
      case '6':printf("Color seleccionado:  TURQUEZA \r\n"); Color_RGB (CYAN);    break;
      case '7':printf("Color seleccionado:  BLANCO   \r\n"); Color_RGB (WHITE);   break;
      default: printf("Todos los LEDs Apagados!!!    \r\n"); Color_RGB (BLACK);   break;
      }
      printf("\n\r Deseas cambiar de color?  \r\n");
      printf("0 = No    1 = Si  \r\n\n");
      Seleccion=getchar();
      if (Seleccion >='1')  goto inicio;
      printf("Desea Terminar el Programa? \r\n\n");
      printf("No = 0        Si = 1 \r\n\n");
      Seleccion=getchar();
      if (Seleccion == '0')  goto inicio;       
      printf("Realmente Desea Terminar el Programa? \r\n\n");
      printf("No = 0        Si = 1 \r\n");
      Seleccion=getchar();  
      if (Seleccion == '0')  goto inicio;     
      goto fin;
    }
    fin:
    printf("Se acabo! \r\n");    
}

/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (Toggle the LED)
        counter = Rate;             // Restablece el contador
     
    } 
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
        led_testigo = 0;        // turn the LED on
        wait_ms(200);           // 200 millisecond
        led_testigo = 1;        // turn the LED off
        wait_ms(1000);          // 1000 millisecond
        terminal.printf("Counter Finish! \r");           
}

/* END Program */

/* END Mbed */ 