/** ###################################################################
**     Filename    : Led_RGB.cpp
**     Project     : mbed
**     Processor   : MKL46Z256VLL4
**     Component   : MKL46Z4
**     Version     : Driver 01.00
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-09-02, 12:27, # CodeGen: 0
**     Abstract    :
**         This is user's library module.
**         Put your library handler code here.
**     Settings    :
**     Contents    :
**         Led_RGB - void Led_RGB(color);
**         T_Led   - void T_Led (tiempo);
**     Author      : Antulio Morgado Valle
**
** ###################################################################*/
/* LED_RGB.c */
#include "mbed.h"
#include "Led_RGB.h"


//#define LED_ROJO    PTE6        // Led RGB Azul
//#define LED_VERDE   PTE3        // Led RGB Verde
//#define LED_AZUL    PTE2        // Led RGB Rojo


//DigitalOut Led_Azul (LED_AZUL);
//DigitalOut Led_Verde(LED_VERDE);
//DigitalOut Led_Rojo (LED_ROJO);

DigitalOut Led_Azul (PTE2);
DigitalOut Led_Verde(PTE3);
DigitalOut Led_Rojo (PTE6);

/*
** ===================================================================
**     Function    :  Led_RGB 
**
**     Description :
**         Enciende el Led RGB con el color seleccionado
**         This method is public. It is used by ATEAM friends only.
**     Parameters  :
**         NAME            - DESCRIPTION
**         color           - Number of color to be sent to the RGB Led
**     Returns     : Nothing
** ===================================================================
*/
void Color_RGB(uint8_t color)
 {  
    if (color & Bit_RED)
        Led_Rojo = ON;
    else 
       Led_Rojo=OFF;
        
    if (color & Bit_GREEN)
        Led_Verde = ON;
    else 
        Led_Verde = OFF;
        
    if (color & Bit_BLUE)
        Led_Azul = ON;
    else 
        Led_Azul = OFF;        
 }
/*
** ===================================================================
**     Function    :  Apaga_Leds (void)
**
**     Description :
**         Asigna el tiempo de encendido del Led seleccionado
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Apaga_Leds (void)
{
    Led_Rojo  = OFF;
    Led_Verde = OFF;
    Led_Azul  = OFF;
}
