/** ###################################################################
**     Filename    : Led_RGB.h
**     Project     : Mbed Library
**     Processor   : MKL46Z256VLL4
**     Component   : LED_RGB
**     Version     : Driver 01.00
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-09-02, 13:57, # CodeGen: 0
**     Abstract    :
**         LED_RGB.h - contains definitions of basic types,
**         register access macros and hardware specific macros
**         which can be used in user application.
**         This is user's definition module.
**     Settings    :
**     Contents    :
**         Led_RGB    - void Led_RGB(uint8_t color);
**         Led_Blink  - void Led_Blink(uint8_t color);
**         Led_Bright - void Led_Bright(uint8_t color, uint8_t porcentaje);
**         Apaga_Leds - void Apaga_Leds(void);
**   Author        : Antulio Morgado Valle
**   Versión       : Beta
**   Revisión      : A
**   Release       : 0
**   Bugs & Fixes  :
**
** ###################################################################*//*
 * Led_RGB.h
 *
 *  Created on: Sep 2, 2013
 *      Author: Antulio Morgado Valle
 */


#ifndef LED_RGB_H_
#define LED_RGB_H_

#include "mbed.h"

/**********************************************************/
/* peripheral access macros                               */
/**********************************************************/
#define ON  1                       // Led Encendido
#define OFF 0                       // Led Apagado
//int ON  = 0;                       // Led Encendido
//int OFF = 1;                       // Led Apagado

/* ----------------------------------------------------------------------------
   -- Enumeración de los pesos de los bits
   ---------------------------------------------------------------------------- */
enum Bits_LED{Bit_RED=1, Bit_GREEN=2, Bit_BLUE=4};

/* ----------------------------------------------------------------------------
   -- Enumeración de los colores
   ---------------------------------------------------------------------------- */
enum color {NEGRO, ROJO, VERDE, AMBAR, AZUL, MAGENTA, CIAN, BLANCO};
#define BLACK NEGRO
#define RED   ROJO
#define GREEN VERDE
#define AMBER AMBAR
#define BLUE  AZUL
#define CYAN  CIAN
#define WHITE BLANCO
/*
+----------------------------------------------------------------------------
| Definición de Funciones Prototipo
+---------------------------------------------------------------------------- 
*/
void Color_RGB(uint8_t color);
void Apaga_Leds (void);

#endif /* LED_RGB_H_ */