#ifndef CHARGER_H
#define CHARGER_H

#include "mbed.h"

#define DEBUG 1

#define MAX_PACK_VOLTAGE 138600.0 // 33 * 4.2
#define MAX_CURRENT 10000.0 //limited by charger
#define MAX_CELL_VOLTAGE 4250 
#define CHARGING_FINISHED_THRESHOLD_VOLTAGE 4200
#define DEEP_DISCHARGE_THRESHOLD_VOLTAGE 3000
#define CHARGING_FINISHED_THRESHOLD_CURRENT 800
#define DEEP_DISCHARGE_MAX_CURRENT 2000
#define PACK_CAPACITY 42 //in Ah

#define CHARGER_MSG_TIMEOUT_MS 6000 
#define BMS_MSG_TIMEOUT_MS     2000 

//Macros for charging to avoid confusion and potentioal errors
#define START_CHARGING 0
#define STOP_CHARGING 1

#define CAN_BUFFER_SIZE 255 //Setting this to be quite large, should be equal to max # of ids expected to receive

// CAN pins
#define CAR_CAN_WRITE_PIN p29
#define CAR_CAN_READ_PIN p30
#define CHARGER_CAN_WRITE_PIN p10
#define CHARGER_CAN_READ_PIN p9

extern uint8_t charger_status; //status packet given by charger, see Elcon CAN Specification in google drive
extern bool precharge_status;
extern bool comms_timeout;
extern bool charger_failure;
extern bool charge_finished;
extern bool bms_error;
extern bool charging;
extern bool bms_timeout;
extern bool charger_timeout;

extern float min_cell_voltage; //mV
extern float max_cell_voltage;//mV

extern float charger_current; //mA
extern float charger_voltage; //mV

extern float desired_current; //mA
extern float desired_voltage; //mV

extern uint8_t charger_control;


#endif
   