#ifndef CANParserCharger_H
#define CANParserCharger_H

#include "CAN_Data.h"
#include "CAN_IDs.h"
#include "charger.h"
#include "Data_types.h"



#define CHARGER_CAN_BIT_RATE 250000 //note this is different to the car CAN bit rate, this is fixed by the charger
#define CHARGER_VI_CONTROL_ID  0x1806E5F4
#define CHARGER_VI_INFO_ID  0x18FF50E5

#define CAN_TIMEOUT_MS 100



//@TODO add some comments

void get_max_min_voltage(CANMessage msg, float &_min_cell_voltage, float &_max_cell_voltage);
void get_battery_status(CANMessage msg, bool &error);
void get_charger_VI_info(CANMessage msg, float &_charger_voltage, float &_charger_current, uint8_t &_charger_status);
void check_precharge_status (CANMessage msg, bool &_precharge_ready);
void get_CAN_data();
void car_CANDataSentCallback();
void charger_CANDataSentCallback();
void car_interruptHandler();
void charger_interruptHandler();
bool idAccepted(int id);
void CAN_Init();

CANMessage generate_charger_control_msg(float _desired_voltage, float _desired_current, uint8_t _charger_control);
CANMessage generate_charger_info_msg(float _charger_voltage, float _charger_current, uint8_t _charger_status, bool _charger_timeout, bool _bms_timeout);
CANMessage generate_charging_finished_msg(); //When this packet is received by the BMU, it causes the BMU to reset its SoC value to 100%

//CAN stuff. Not that there are two sets because there are two separate CAN buses here; one to communicate with the charger, and one to communicate with the rest of the car (importantly the BMS).
//The reason that there are two separate CAN buses is because the charger uses the extended CAN frame format, with a 29 bit ID, whereas the car uses the default 11 bit ID.
extern CAN car_can; //Create a CAN object to handle CAN comms
extern CANMessage car_buffer[CAN_BUFFER_SIZE]; //CAN receive buffer
extern bool car_safe_to_write[CAN_BUFFER_SIZE]; //Semaphore bit indicating that it's safe to write to the software buffer
extern bool car_CAN_data_sent;

extern CAN charger_can; //Create a CAN object to handle CAN comms
extern CANMessage charger_buffer[CAN_BUFFER_SIZE]; //CAN receive buffer
extern bool charger_safe_to_write[CAN_BUFFER_SIZE]; //Semaphore bit indicating that it's safe to write to the software buffer
extern bool charger_CAN_data_sent;
#endif