/**
 * Copyright (c) 2015 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "XBeeLib.h"
#include "CAN_Parser_Telemetry.h"
#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
using namespace CAN_IDs;
#endif

#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)

//#error "Replace next define with the LSB of the remote module's 64-bit address (SL parameter)"
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x4076A4CB)

//#error "Replace next define with the remote module's 16-bit address (MY parameter)"
#define REMOTE_NODE_ADDR16      ((uint16_t)0x00)

#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)

#define DEBUG                   0
using namespace XBeeLib;

Serial *log_serial;

static void send_broadcast_data(XBee802& xbee, uint8_t *data, uint16_t data_len)
{
    const TxStatus txStatus = xbee.send_data_broadcast(data, data_len);

    if (txStatus == TxStatusSuccess)
        printf("send_broadcast_data OK\r\n");
    else
        printf("send_broadcast_data failed with %d\r\n", (int) txStatus);
}

static void send_data_to_remote_node(XBee802& xbee, const RemoteXBee802& RemoteDevice, uint8_t *data, uint16_t data_len)
{
    const TxStatus txStatus = xbee.send_data(RemoteDevice, data, data_len);

    if (txStatus == TxStatusSuccess) {
        if (DEBUG) {
        printf("send_data_to_remote_node OK\r\n");
        }
        }
    else
        printf("send_data_to_remote_node failed with %d\r\n", (int) txStatus);
}

static void readFromVolBufferandRedirect2Xbee(XBee802& xbee, const RemoteXBee802 remoteDevice64b)
{
    if(DEBUG) printf("In main loop \r\n");
    uint8_t actualData[10];
    //Import the data from the buffer into a non-volatile, more usable format
    CAN_Data can_data[CAN_BUFFER_SIZE]; //container for all of the raw data
    int received_CAN_IDs[CAN_BUFFER_SIZE]; //needed to keep track of which IDs we've received so far
    for (int i = 0; i<CAN_BUFFER_SIZE; i++) {
        safe_to_write[i] = false;
        can_data[i].importCANData(buffer[i]);
        received_CAN_IDs[i] = buffer[i].id;
        buffer[i] = 0;
        safe_to_write[i] = true;

        if (received_CAN_IDs[i]!=BLANK_ID) {
            if (DEBUG) printf("Picked up CAN packet! \r\n");
            if (DEBUG) printf("CAN ID is %x \r\n", received_CAN_IDs[i]);
            //Xbee packet format is such that byte 1 = CAN ID, byte 1-9 = CAN data...
            actualData[0]=(uint8_t)received_CAN_IDs[i];
            actualData[1]=(uint8_t)(received_CAN_IDs[i]>>8);
            //printf("actualData[1] is %x \r\n", actualData[1]);
            for (int x=0; x<8; x++) {
                actualData[x+2]=can_data[i].get_u8(x);
            }
            send_data_to_remote_node(xbee, remoteDevice64b, actualData, 10);
            wait_ms(100);
            if (DEBUG) printf("\r\n");
        }
    }
}

//Serial *log_serial;
int main()
{
    CAN_Init();
    CANIDsListUpdater();
    log_serial = new Serial(DEBUG_TX, DEBUG_RX);
    log_serial->baud(9600);
    //log_serial->printf("Sample application to demo how to send unicast and broadcast data with the XBee802\r\n\r\n");
    //log_serial->printf(XB_LIB_BANNER);

#if defined(ENABLE_LOGGING)
    new DigiLoggerMbedSerial(log_serial, LogLevelInfo);
#endif

    XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);

    RadioStatus radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);

    const RemoteXBee802 remoteDevice64b = RemoteXBee802(REMOTE_NODE_ADDR64);
    const RemoteXBee802 remoteDevice16b = RemoteXBee802(REMOTE_NODE_ADDR16);
    while (1) {
        //send_broadcast_data(xbee);
        readFromVolBufferandRedirect2Xbee(xbee, remoteDevice64b);
        wait_ms(200);
        //wait(1);
        //send_data_to_remote_node(xbee, remoteDevice16b);
    }
    delete(log_serial);
}