#include "CAN_Data.h"
#include "CAN_IDs.h"
#include "mbed.h"
#include "PINNAMES_mbed.h"

#define CAN_TIMEOUT_MS 100
#define CAN_BUFFER_SIZE 255

void interruptHandler();
bool idAccepted(int id);
void CAN_Init();
bool can_send(CANMessage msg);
void CANDataSentCallback(void);
void CANIDsListUpdater(void);
CANMessage generateCANPackets(const uint8_t *xbeeData);

extern CAN can; //Create a CAN object to handle CAN comms

//Software buffer for receiving CAN messages
extern CANMessage buffer[CAN_BUFFER_SIZE]; //CAN receive buffer
extern bool safe_to_write[CAN_BUFFER_SIZE]; //Semaphore bit indicating that it's safe to write to the software buffer
extern bool CAN_data_sent;
extern int acceptedCANIDs[CAN_BUFFER_SIZE];