#include "CAN_Parser_Telemetry.h"
#define DEBUG                   1

using namespace CAN_IDs;

CAN can(CAN_READ_PIN, CAN_WRITE_PIN); //Create a CAN object to handle CAN comms

//Software buffer for receiving CAN messages
CANMessage buffer[CAN_BUFFER_SIZE]; //CAN receive buffer
bool safe_to_write[CAN_BUFFER_SIZE]; //Semaphore bit indicating that it's safe to write to the software buffer
bool CAN_data_sent;
int acceptedCANIDs[CAN_BUFFER_SIZE];

void CAN_Init()
{
    printf("In CAN init \r\n");
    //Initialise CAN buffer
    for(int i=0; i<CAN_BUFFER_SIZE; i++) {
        buffer[i].id = BLANK_ID;
        //("%d",buffer[i].id);
        safe_to_write[i]= true;
    }

    //Initialise CAN stuff, attach CAN interrupt handlers
    can.frequency(CAN_BIT_RATE); //set transmission rate to agreed bit rate (ELEC-006)
    can.reset(); // (FUNC-018)
    can.attach(&interruptHandler, CAN::RxIrq); //receive interrupt handler
    can.attach(&CANDataSentCallback, CAN::TxIrq); //send interrupt handler
}

void interruptHandler()
{
    //printf("Interrupt Handler called \r\n");
    CANMessage msg;
    can.read(msg);
    //if(DEBUG) printf("id %d incoming \r\n", msg.id);
    if(idAccepted(msg.id)) {
        for(int i=0; i<CAN_BUFFER_SIZE; i++) {
            //printf("In idAccepted loop");
            if((buffer[i].id == msg.id || buffer[i].id==BLANK_ID) && safe_to_write[i]) {
                //("id %d added to buffer \r\n", msg.id);
                buffer[i] = msg;
                //printf("%x \r\n", msg.id);
                //return required so that only first blank buffer entry is converted to incoming message ID each time new message ID is encountered
                return;
            }
        }
    }
}

bool idAccepted(int id)
{
    for (int i=0; i<CAN_BUFFER_SIZE; i++) {
        if (id==acceptedCANIDs[i]) {
            //printf("idAccepted \r\n");
            return true;
        }
    }
    return false;
}

bool can_send(CANMessage msg)
{
    Timer t;
    CAN_data_sent = false;
    t.start();
    can.write(msg);
    //printf("CAN message sent with id %x \r\n", msg.id);
    while(!CAN_data_sent && t.read_ms() < CAN_TIMEOUT_MS);
    if (t.read_ms() > CAN_TIMEOUT_MS) return false;
    else return true;
}

void CANDataSentCallback(void)
{
    CAN_data_sent = true;
}

void CANIDsListUpdater(void)
{
    acceptedCANIDs[0]= MOTOR_CONTROLLER_BASE_ID + MOTOR_STATUS_ID;
    acceptedCANIDs[1]= MOTOR_CONTROLLER_BASE_ID + MOTOR_VELOCITY_ID;
    acceptedCANIDs[2]= BMS_BASE_ID + BATTERY_SOC_ID;
    acceptedCANIDs[3]= BMS_BASE_ID + BATTERY_VI_ID;
    acceptedCANIDs[4]= BMS_BASE_ID + BATTERY_STATUS_ID;
    acceptedCANIDs[5]= BCU_STATUS_ID;
    acceptedCANIDs[5]= BMS_BASE_ID + IVTA_ID;
    acceptedCANIDs[6]= BMS_BASE_ID + MAX_MIN_VOLTAGE;
    acceptedCANIDs[7]= DRIVER_CONTROLS_BASE_ID + MOTOR_DRIVE_CMD;
    acceptedCANIDs[8]= DRIVER_CONTROLS_BASE_ID + MOTOR_POWER_CMD;
    acceptedCANIDs[9]= 0x40B; //motor controller heatsink and motor temp
    acceptedCANIDs[10]=AMBIENT_TEMP_ID;
    acceptedCANIDs[11]=0x404; //motor controller phase currents
    acceptedCANIDs[12]=CHARGER_ID;
}

CANMessage generateCANPackets(const uint8_t *xbeeData)
{
    CANMessage msg;
    msg.id=(uint16_t)xbeeData[0]+((uint16_t)(xbeeData[1])<<8);
    //for (int i=0; i<10; i++) {
        //if (DEBUG) printf("byte %d is %x \r\n", i, xbeeData[i]);
        //}
    //if (DEBUG) printf("CAN ID is %x \r\n", msg.id);
    msg.len = 8;
    //CAN_Data data;
    for (int i=0; i<8; i++) {
        msg.data[i]=xbeeData[i+2];
    }
    return msg;
}


