/*
* Code for identifying address and temperature of DS1820 1-Wire Thermometers by Maxim
* Uses the DS1820 library written by Michael Hagberg and Fernando Caamaño, with some slight modifications
* NOTE: THIS IS NOT CURRENTLY BEING USED IN THE BMU CODE AS TEMPERATURE MEASUREMENTS ARE CURRENTLY BEING COLLATED BY A SEPARATE PCB
*/
#include "Temperature.h"
#define DEBUG 0
 
DS1820* probe[MAX_PROBES];
int devices_found;
DigitalOut isotherm_12V_pin(ISOTHERM_12V_PIN); 
 
void temperature_init()
{
    //DigitalOut isotherm_12V_pin(ISOTHERM_12V_PIN);
    isotherm_12V_pin = 1;
    int address_byte_count;
    // Initialize the probe array to DS1820 objects
    for (int i = 0; i < MAX_PROBES; i++)
        probe[i] = new DS1820(DATA_PIN, PARASITE_PIN);
    // Initialize global state variables
    probe[0]->search_ROM_setup();
    // Loop to find all devices on the data line
    while (probe[devices_found]->search_ROM() and devices_found<MAX_PROBES-1)
        devices_found++;
    
    isotherm_12V_pin = 0;
    // If maximum number of probes are found,
    // bump the counter to include the last array entry
    if (probe[devices_found]->ROM[0] != 0xFF)
        devices_found++;
 
    if (devices_found==0)
        if (DEBUG) printf("No devices found");
    else {
        if (DEBUG) printf("\n%d device(s) found!\r\n\n" ,devices_found);
        for (int i=0; i<devices_found; i++) {
            if (DEBUG) printf("Device %d address is: \r\n", i+1);
            for(address_byte_count=0; address_byte_count<8; address_byte_count++) {
                if (DEBUG) printf("0x%02x", probe[i]->ROM[address_byte_count]);
                if(address_byte_count == 7) {
                    if (DEBUG) printf("\r\n\n");
                }
                else printf(", ");
            }
        }
    }
}    
    