#include "EEPROM_I2C.h"

I2C i2c(I2C_DATA, I2C_CLOCK);

/* Dont think this will be used
// Write individual byte
void i2c_write(int start_address,char data_out){

    char data[3];
    data[0] = start_address;
    data[1] = start_address;
    data[2] = data_out;
    i2c.write(ADDRESS_1, data, 3, false);
}
 */
// Read individual byte
/* Dont think this will be used
char i2c_read(int start_address){
    char cmd[3];
    cmd[0] = start_address;
    cmd[1] = start_address;
    i2c.write(ADDRESS_1, cmd, 2, true);

    char data_out;
    i2c.read(ADDRESS_1, &data_out, 1, false);
    return data_out;
}
 */
// Page write
void i2c_page_write(uint16_t start_address,int length, char data_out[] )
{
    char cmd[2+length];
    cmd[0] = (start_address >> 8) & 0x00FF;
    cmd[1] = start_address & 0x00FF; 
    for(int  i = 0; i< length ; i++) {
        cmd[i+2] = data_out[i];
    }

    i2c.write(ADDRESS_1, cmd, length + 2, false);
}
// Page read. Wait 10 milliseconds after a write at least before reading.
void i2c_page_read(uint16_t start_address, int length, char data_in[])
{
    char cmd[2];
    cmd[0] = (start_address >> 8) & 0x00FF;
    cmd[1] = start_address & 0x00FF; //Same comment as for write
    i2c.write(ADDRESS_1, cmd, 2, true);
    wait_us(10);
    i2c.read(ADDRESS_1, data_in, length, false);
}
