#include "CAN_Data.h"
#include "CAN_IDs.h"
#include "Data_Types_BMU.h"

#ifndef CANParserBMU_H
#define CANParserBMU_H

CANMessage createTemperatureTelemetry(uint8_t offset, char * ROMID, float Temperature);

individual_temperature decodeTemperatureTelemetry(CANMessage msg); //working

CANMessage createVoltageTelemetry(int ID, uint16_t voltage[]); //working

bool decodeVoltageTelemetry(CANMessage msg, CMU_voltage readings[NO_CMUS]); //working

CANMessage createPackSOC(float SOC, float percentageCharge); //working

float decodePackSOC(CANMessage msg); //working

float decodePackSOCPercentage(CANMessage msg);//working

CANMessage createCellVoltageMAXMIN(pack_voltage_extremes max_voltage, pack_voltage_extremes min_voltage);

void decodeCellVoltageMAXMIN(CANMessage msg, pack_voltage_extremes &min, pack_voltage_extremes &max);

CANMessage createCellTemperatureMAXMIN(pack_temperature_extremes ex_temperature, bool isMin);

pack_temperature_extremes decodeCellTemperatureMAXMIN(CANMessage msg);

CANMessage createBatteryVI(uint32_t batteryVoltage,float batteryCurrent);

uint32_t decodeBatteryVoltage(CANMessage msg); //Works

float decodeBatteryCurrent(CANMessage msg); //Works

CANMessage createBatteryPower(uint32_t batteryVoltage, float batteryCurrent);

CANMessage createIVTACurrent(int32_t current);

int32_t decodeIVTACurrent(CANMessage msg);

CANMessage createBatteryPackStatus(uint32_t status);

uint32_t decodeBatteryPackStatus(CANMessage msg);

CANMessage createBMSHeartbeat(uint32_t val1, uint32_t val2);

CANMessage createEEPROMReset(float init_SOC, float init_SOC_Percent);

float decodeEEPROMSOC(CANMessage msg);

float decodeEEPROMSOCPercentage(CANMessage msg);


union float2byte {
    float f;
    char b[sizeof(float)];
};

#endif