
#ifndef __CUBE_CRYPTO_H__
#define __CUBE_CRYPTO_H__

#include "mbed.h"
#include <Timer.h>
#include "mbedtls/platform.h"
#include <string.h>
#include "mbedtls/cipher.h"
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "lib_CEBF746.h"

#if DEBUG_LEVEL > 0
#include "mbedtls/debug.h"
#endif
#if defined(MBEDTLS_MEMORY_BUFFER_ALLOC_C)
#include "mbedtls/memory_buffer_alloc.h"
#endif

/*
 *  random number generate seed
 */
 
const uint8_t random_num_seed[16]={
    0x74, 0x11, 0xF0, 0x45, 0xD6, 0xA4, 0x3F, 0x69,
    0x18, 0xC6, 0x75, 0x42, 0xDF, 0x4C, 0xA7, 0x84
};

// 0:reset 1:encrypt 2:decrypt 3~5:MODE 6:WORK 7:NON


/*
 *  AES crypto Struct
 */
typedef struct
{
    uint8_t cmd;
    //uint8_t data[16];
    uint8_t* data;
    uint16_t key_crc;
}
sec_spi_data;

 
typedef struct
{
    uint8_t iv[16];
    uint8_t key[32];
    uint8_t key_size;
    uint16_t key_crc;
    uint8_t keyindex;
}
cube_sec_key;

typedef struct
{
    uint8_t input_data[16];
    uint8_t output_data[16];
    uint8_t input_data_size;
    uint8_t output_data_size;
}
cube_sec_data;

typedef struct
{
    mbedtls_aes_context mbed_ctx;
    uint8_t cmd;
    cube_sec_data sec_data;
    cube_sec_key sec_key;
}
cube_sec_context;

enum sec_config
{
    INIT = 0,
    ENCRYPT,
    DECRYPT,
    MODE,
    WORK=6,
    EXTERN2=7,
};

// 0:reset 1:encrypt 2:decrypt 3~5:MODE 6:WORK 7:NON

//SET
#define AES_INIT            (0b01<<INIT)
#define AES_INIT_NON        (0b00<<INIT)
#define AES_ENCRYPT_ON      (0b01<<ENCRYPT)
#define AES_ENCRYPT_OFF     (0b00<<ENCRYPT)
#define AES_DECRYPT_ON      (0b01<<DECRYPT)
#define AES_DECRYPT_OFF     (0b00<<DECRYPT)
#define AES_MODE_ECB        (0b000<<MODE)
#define AES_MODE_CBC        (0b001<<MODE)
#define AES_WORK_ON         (0b01<<WORK)
#define AES_WORK_OFF        (0b00<<WORK)

//STATUS
#define INIT_STATUS     (0b01<<INIT)
#define ENCRYPT_STATUS  (0b01<<ENCRYPT)
#define DECRYPT_STATUS  (0b01<<DECRYPT)
#define MODE_STATUS     (0b111<<MODE)
#define WORK_STATUS     (0b01<<WORK)
#define EXTERN2_STATUS  (0b01<<EXTERN2)

#define CONFIRM 0xff
 
#define SET_STATUS(reg, status, set)  reg = (((~status) & reg) | set)
#define GET_STATUS(reg, status)   ( status & reg )

/*
 *  AES crypto func
 */
spiDataStr getEncTxPacket(void);
spiDataStr getDecTxPacket(void);
uint8_t cube_get_status(void);
void cube_sec_init(void);
void cube_sec_struct_init(cube_sec_context *cube_ctx);
bool cube_AES_setkey(cube_sec_context *cube_ctx);
bool cube_sec_key_reset(cube_sec_context *cube_ctx);
int32_t cube_AES_encrypt(cube_sec_context *cube_ctx);
int32_t cube_AES_decrypt(cube_sec_context *cube_ctx);
bool cube_AES_read_data(cube_sec_context *cube_ctx, uint8_t *output_data, uint32_t size);
int32_t cube_random_number_generate(const uint8_t *seed, uint8_t *num, uint8_t size);
bool cube_crypt_spi_cmd_set(sec_spi_data *spi_data);
void cube_Thread_AES_decrypt(void const *argument);
void cube_Thread_AES_encrypt(void const *argument);

/*
 * print func
 */

void print_mbedtls_aes_context(mbedtls_aes_context printStr);
void print_cube_sec_data(cube_sec_data printStr);
void print_cube_sec_key(cube_sec_key printStr);
void print_cube_sec_context(cube_sec_context printStr);
void print_hex(const char *title, const unsigned char buf[], size_t len);



extern cube_sec_context Encrypt_ctx;
extern cube_sec_context Decrypt_ctx;

#endif  /* __CUBE_CRYPTO_H__ */