#include <stdint.h>

/** @brief This function calculates a 16-bit CRC.
 *
 *  @param[in] length number of bytes in data buffer
 *  @param[in] data pointer to data
 *  @param[out] 2byte crc  pointer to calculated CRC (high byte at crc[0])
 */
void cube_crc_16(uint16_t length, uint8_t *data, uint16_t *crc)
{
    uint8_t counter;
    uint8_t crcLow = 0, crcHigh = 0, crcCarry;
    uint8_t polyLow = 0x05, polyHigh = 0x80;
    uint8_t shiftRegister;
    uint8_t dataBit, crcBit;
    for (counter = 0; counter < length; counter++) {
        for (shiftRegister = 0x80; shiftRegister > 0x00; shiftRegister >>= 1) {
            dataBit = (data[counter] & shiftRegister) ? 1 : 0;
            crcBit = crcHigh >> 7;
// Shift CRC to the left by 1.
            crcCarry = crcLow >> 7;
            crcLow <<= 1;
            crcHigh <<= 1;
            crcHigh |= crcCarry;
            if ((dataBit ^ crcBit) != 0) {
                crcLow ^= polyLow;
                crcHigh ^= polyHigh;
            }
        }
    }
    
    *crc = (crcHigh << 8) | crcLow;
    //crc[0] = crcHigh;
    //crc[1] = crcLow;
}

/** @brief compare 2byte crc pointer
 *
 *  @param[in] crc1 first 2byte crc pointer
 *  @param[in] crc2 second 2byte crc pointer
 *  @return same is true, other is false
 */
bool cube_crc_compare(uint16_t crc1, uint16_t crc2)
{
    bool ret = false;
    if( crc1 == crc2 )
    {
        ret = true;
    }
    return ret;
} 


/** @brief cube_crc_16 test func()
 *
 *  @return sucess is true, error is false
 */
bool test_cube_crc_16(void)
{
    bool ret = false;    
    uint8_t testData[] = {0x09, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00};
    uint16_t validateCrc = 0xF960;
    uint16_t outCrc = 0;
    
    cube_crc_16(sizeof(testData), testData, &outCrc);
    if( validateCrc == outCrc )
    {
        ret = true;
    }
    return ret;
}