#ifndef _CUBE_SPI_H_
#define _CUBE_SPI_H_

#include "mbed.h" 

// ======== SPI Master Pin define
#define SPI_SCLK    PA_5
#define SPI_MISO    PA_6
#define SPI_MOSI    PA_7
#define SPI_SSEL    PA_4


#define SPI_CONFIG_BIT          8
#define SPI_CONFIG_FREQUENCY    1000000         // 1Mhz
//#define SPI_CONFIG_FREQUENCY    50000000      // 50Mhz

#define SPI_WAIT(us)        wait_us(us)

typedef struct _cube_spi_master_t{
    SPI * spi;
    DigitalOut * cs;  
} cube_spi_master_t;

void spi_master_init(cube_spi_master_t* pSPIHandle);
void spi_master_start(cube_spi_master_t* pSPIHandle);
void spi_master_end(cube_spi_master_t* pSPIHandle);
void spi_dummy_write(cube_spi_master_t* pSPIHandle);

#endif /* _CUBE_SPI_H_ */