#include "mbed.h"
#include "lib_spi_master.h"
static bool spi_master_init_flag = false;

void spi_master_init(cube_spi_master_t* pSPIHandle)
{
    //SPI spi_master(SPI_MOSI, SPI_MISO, SPI_SCLK); // MOSI, MISO, SCLK(CLK,SCK)
    //DigitalOut cs(SPI_SSEL);
    
    static SPI spi_master(SPI_MOSI, SPI_MISO, SPI_SCLK); // MOSI, MISO, SCLK(CLK,SCK)
    static DigitalOut cs(SPI_SSEL);
    
    pSPIHandle->spi = &spi_master;
    pSPIHandle->cs  = &cs;
    
    
    pSPIHandle->spi->format(SPI_CONFIG_BIT, 0);
    pSPIHandle->spi->frequency(SPI_CONFIG_FREQUENCY);
    printf("SPI Init.. Packet bit size=[%d] Frequency=[%d]Mhz\n", SPI_CONFIG_BIT, (SPI_CONFIG_FREQUENCY/1000000));
    
    
    spi_dummy_write(pSPIHandle);
    spi_dummy_write(pSPIHandle);
    spi_dummy_write(pSPIHandle);
    spi_dummy_write(pSPIHandle);
    spi_dummy_write(pSPIHandle);
        
    spi_master_init_flag = true;
}


/** @brief spi master start
 *
 */
void spi_master_start(cube_spi_master_t* pSPIHandle)
{
    pSPIHandle->spi->lock();
    *(pSPIHandle->cs) = 0;
    SPI_WAIT(10);
}

/** @brief spi master end
 *
 */
void spi_master_end(cube_spi_master_t* pSPIHandle)
{
    SPI_WAIT(10);
    *(pSPIHandle->cs) = 1;
    pSPIHandle->spi->unlock();
}

/** @brief spi master dummy write
 *
 */
void spi_dummy_write(cube_spi_master_t* pSPIHandle)
{
    
    spi_master_start(pSPIHandle);
    pSPIHandle->spi->write(0x00);
    spi_master_end(pSPIHandle);
    SPI_WAIT(10);
    
}
