#ifndef _CUBE_CEBF746_H_
#define _CUBE_CEBF746_H_



#define DEBUG_CEBF746
#ifdef DEBUG_CEBF746
#define PRINTD_CEBF746(arg1,arg2...)    printf(arg1,##arg2)
#endif

#define CEBF746_CMD_WAIT()  SPI_WAIT(50)

#define CEB_BUF_SIZE    16
#define CEB_CRC_SIZE    2
#define WRITE_SELF_TEST_RET_CODE    0xA0
#define WRITE_SELF_TEST_DATA    {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10}      // 16byte data
#define READ_SELF_TEST_DATA     "ReadTestString-"      // 16byte data

/* CEBF716_FUNCTION */
typedef enum {
    FUNC_READ_STATUS = 0x01,                  // read status register
    FUNC_WRITE_ENC_DATA = 0x02,               // 암호화 필요 데이터 Write
    FUNC_READ_ENC_DATA = 0x03,                // 암호화된 데이터 Read
    FUNC_WRITE_DEC_DATA = 0x04,               // 암호화 필요 데이터 Write
    FUNC_READ_DEC_DATA = 0x05,                // 복호화된 데이터 Read
    FUNC_WRITE_SELF_TEST = 0x80,              // 
    FUNC_READ_SELF_TEST = 0x81,               // 
} CEBF716_FUNCTION;





/* CEBF716_COMMAND_RETURN_CODE */
typedef enum {
    SUCESS = 0x00,     // No errors
    
    
} CEBF716_COMMAND_RETURN_CODE;


typedef struct _encDataStr{
    uint8_t     encData[16];    // 
    uint16_t    keyCrc;
} encDataStr;

typedef struct _spiDataStr{
    uint16_t    size;           // buf + crc16 size
    uint8_t     *buf;
    uint16_t    keycrc16;          // crc16 of buf[]
    uint16_t    crc16;          // crc16 of buf[]
} spiDataStr;


void cebf746_use_init(void);
void cebf746_print_cmd(uint8_t opCode);
int16_t cebf746_packet_write(CEBF716_FUNCTION cebf746_command, spiDataStr* sendPacketStruct);
int16_t cebf746_packet_read(CEBF716_FUNCTION cebf746_command, spiDataStr* readPacketStruct);
void cebf746_set_packet(spiDataStr* setSpiDataStr, uint16_t size, uint8_t * buf);
void _cebf746_print_packet(uint16_t size, uint8_t* buf, uint16_t crc16);
void cebf746_print_packet(spiDataStr* in);

#endif /* _CUBE_CEBF746_H_ */
