#include "mbed.h"
#include "lib_CEBF746.h"
#include "lib_crc.h"
#include "lib_spi_master.h"

static cube_spi_master_t cebf746_master;
uint8_t readSelfTestValidateData[CEB_BUF_SIZE] = READ_SELF_TEST_DATA;  // self test 踰꾪띁
uint8_t writeSelfTestValidateData[CEB_BUF_SIZE] = WRITE_SELF_TEST_DATA;  // self test 踰꾪띁

void cebf746_use_init(void)
{
    spi_master_init(&cebf746_master);
}

void cebf746_print_cmd(uint8_t opCode)
{
    printf("COMMAND : [%02X] : ",opCode);
    switch(opCode)
    {
        case FUNC_READ_STATUS:
            printf("FUNC_READ_STATUS");
        break;
        
        case FUNC_WRITE_ENC_DATA:
            printf("FUNC_WRITE_ENC_DATA");
        break;
        
        case FUNC_READ_ENC_DATA:
            printf("FUNC_READ_ENC_DATA");
        break;
        
        case FUNC_WRITE_DEC_DATA:
            printf("FUNC_WRITE_DEC_DATA");
        break;
        
        case FUNC_READ_DEC_DATA:
            printf("FUNC_READ_DEC_DATA");
        break;
        
        case FUNC_WRITE_SELF_TEST:
            printf("FUNC_WRITE_SELF_TEST");
        break;
        
        case FUNC_READ_SELF_TEST:
            printf("FUNC_READ_SELF_TEST");
        break;
        
        default:
            printf("unknow");
        break;
    }
    printf("\n");
}
void cebf746_cmd_write(CEBF716_FUNCTION cebf746_command)
{
    cebf746_master.spi->write(cebf746_command);
    CEBF746_CMD_WAIT(); 
}


uint8_t cebf746_reg_read()  //CEBF716_FUNCTION cebf746_command, spiDataStr* sendPacketStruct
{
    uint8_t ret = 0;
    
    spi_master_start(&cebf746_master);                          
    cebf746_cmd_write(FUNC_READ_STATUS);    
    //SPI_WAIT(1000);     // wait return code
    ret = cebf746_master.spi->write(0);
    printf("-----------------\n");
    spi_master_end(&cebf746_master);
    
    return ret;
}

bool cebf746_selfTest_packet_compare(uint8_t* orignalBuf16, spiDataStr* comparePacketStruct)
{
    bool ret = true;
    
    
    if(CEB_BUF_SIZE != comparePacketStruct->size)      // size check
    {
        ret = false;
        printf("(Size compare Fail \'%d!=%d\') ", CEB_BUF_SIZE, comparePacketStruct->size);
    }
    else
    {  
        int iCnt = 0;          
        for( ; iCnt < CEB_BUF_SIZE ; ++iCnt)
        {           
            if(orignalBuf16[iCnt] != comparePacketStruct->buf[iCnt])
            {
                break;                    
            }
        }
        if(iCnt != CEB_BUF_SIZE)        // data check
        {
            ret = false;
            printf("(Buf compare Fail) ");
        }
        else
        {
            uint16_t crc1 = 0;
            uint16_t crc2 = 0;
            
            cube_crc_16(CEB_BUF_SIZE, orignalBuf16, &crc1);
            cube_crc_16(comparePacketStruct->size, comparePacketStruct->buf, &crc2);
            if(false == cube_crc_compare(crc1, crc2))
            {
                ret = false;
                printf("(CRC compare Fail \'%04X!=%04X\') ", crc1, crc2);
            }
        }
        
        if(true == ret)
        {
            printf("(OK)");
        }
        else
        {
            cebf746_print_packet(comparePacketStruct);
        }
        printf("\n");
    }
    return ret;
}

/** @brief CEBF746 �뙣�궥 Write
 *
 *  @param spi_handler SPI �빖�뱾�윭
 *  @param cebf746_command �넚�떊 而ㅻ㎤�뱶 OP-Code
 *  @param sendPacketStruct �쟾�넚 �뙣�궥
 *  @return 0 is valid hex format, other is error
 */
int16_t cebf746_packet_write(CEBF716_FUNCTION cebf746_command, spiDataStr* sendPacketStruct)
{
    uint16_t crc=0;
    int16_t ret = -1;    
    //printf("cebf746_packet_write()\n");
    
    printf("\n");
    switch(cebf746_command)
    {
        case FUNC_WRITE_ENC_DATA:   /* FUNC_WRITE_ENC_DATA */
            printf("FUNC_WRITE_ENC_DATA\n");
            cube_crc_16(sendPacketStruct->size, sendPacketStruct->buf, &crc);
            sendPacketStruct->crc16 = crc;
            
            // ----- SPI Start
            spi_master_start(&cebf746_master);
            cebf746_cmd_write(FUNC_WRITE_ENC_DATA);
                    
            cebf746_master.spi->write((sendPacketStruct->size >> 8) & 0xFF);       // size upper
            cebf746_master.spi->write((sendPacketStruct->size     ) & 0xFF);       // size lower    
            
            for(int iCnt = 0 ; iCnt < sendPacketStruct->size ; ++iCnt)      // data sendPacketStruct
            {
                cebf746_master.spi->write(*(sendPacketStruct->buf+iCnt));
            }    
            cebf746_master.spi->write((crc >> 8) & 0xFF);              // crc upper
            cebf746_master.spi->write((crc     ) & 0xFF);              // crc lower
            
            //SPI_WAIT(1000);     // wait return code
            ret = cebf746_master.spi->write(0);
            spi_master_end(&cebf746_master);
            // ----- SPI End
            
            cebf746_print_packet(sendPacketStruct);
            
            
        break;  /* FUNC_WRITE_ENC_DATA */
        
        case FUNC_WRITE_DEC_DATA:   /* FUNC_WRITE_DEC_DATA */
            printf("FUNC_WRITE_DEC_DATA\n");
            cube_crc_16(sendPacketStruct->size, sendPacketStruct->buf, &crc);
            sendPacketStruct->crc16 = crc;

            // ----- SPI Start
            spi_master_start(&cebf746_master);
            cebf746_cmd_write(FUNC_WRITE_DEC_DATA);

            cebf746_master.spi->write((sendPacketStruct->size >> 8) & 0xFF);       // size upper
            cebf746_master.spi->write((sendPacketStruct->size     ) & 0xFF);       // size lower

            for(int iCnt = 0 ; iCnt < sendPacketStruct->size ; ++iCnt)      // data sendPacketStruct
            {
                cebf746_master.spi->write(*(sendPacketStruct->buf+iCnt));
            }
            cebf746_master.spi->write((crc >> 8) & 0xFF);              // crc upper
            cebf746_master.spi->write((crc     ) & 0xFF);              // crc lower

            //SPI_WAIT(1000);     // wait return code
            ret = cebf746_master.spi->write(0);
            spi_master_end(&cebf746_master);
            // ----- SPI End

            cebf746_print_packet(sendPacketStruct);
        break;  /* FUNC_WRITE_DEC_DATA */
        
        case FUNC_WRITE_SELF_TEST:  /* FUNC_WRITE_SELF_TEST */            
            cube_crc_16(sendPacketStruct->size, sendPacketStruct->buf, &crc);
            sendPacketStruct->crc16 = crc;
        
            // ----- SPI Start
            spi_master_start(&cebf746_master);
            cebf746_cmd_write(FUNC_WRITE_SELF_TEST);


            cebf746_master.spi->write((sendPacketStruct->size >> 8) & 0xFF);       // size upper
            cebf746_master.spi->write((sendPacketStruct->size     ) & 0xFF);       // size lower    
            
            for(int iCnt = 0 ; iCnt < sendPacketStruct->size ; ++iCnt)      // data sendPacketStruct
            {
                cebf746_master.spi->write(*(sendPacketStruct->buf+iCnt));
            }    
            cebf746_master.spi->write((crc >> 8) & 0xFF);              // crc upper
            cebf746_master.spi->write((crc     ) & 0xFF);              // crc lower
            
            SPI_WAIT(50);     // 161024 test ok : 50us
            ret = cebf746_master.spi->write(0);
            spi_master_end(&cebf746_master);
            // ----- SPI End
            
            if(WRITE_SELF_TEST_RET_CODE == ret)
            {
                printf("[INFO] CEBF746 Write Self Test : (OK[%02X])\n", ret);
                cebf746_print_packet(sendPacketStruct);
            }
            else
            {
                printf("[INFO] CEBF746 Write Self Test : (***Error[%02X]***)\n", ret);
            }
            //cebf746_selfTest_packet_compare(sendPacketStruct->buf, )
        
        break;  /* FUNC_WRITE_SELF_TEST */
                
        default :
            ret = -1;
            printf("[ERROR] cebf746_packet_read();\n");
            printf("[ERROR] unknown command code=[%d]\n", cebf746_command);
        return ret;        
    }
    
    
    
    
    
    return ret;
}


/** @brief CEBF746 �뙣�궥 Read
 *
 *  @param spi_handler SPI �빖�뱾�윭
 *  @param cebf746_command �넚�떊 而ㅻ㎤�뱶 OP-Code
 *  @param readPacketStruct �쟾�넚 �뙣�궥
 *  @return 0 is valid hex format, other is error
 */
int16_t cebf746_packet_read(CEBF716_FUNCTION cebf746_command, spiDataStr* readPacketStruct)
{
    uint16_t tempCrc=0;
    int16_t ret = -1;    
    
    //printf("cebf746_packet_write()\n");
    
    
    
    printf("\n");
    switch(cebf746_command)
    {
        case FUNC_READ_STATUS:  /* FUNC_READ_STATUS */                        
            ret = cebf746_reg_read();            
        break;  /* FUNC_READ_STATUS */
        
        case FUNC_READ_ENC_DATA:    /* FUNC_READ_ENC_DATA */    
            printf("FUNC_READ_ENC_DATA:\n");
            memset(readPacketStruct->buf, 0, readPacketStruct->size);
            readPacketStruct->size = 0;
            readPacketStruct->crc16 = 0;
            
            // ---- SPI Start
            spi_master_start(&cebf746_master);                          
            cebf746_cmd_write(FUNC_READ_ENC_DATA);
            //SPI_WAIT(500);

                        
            readPacketStruct->size = ((cebf746_master.spi->write(0) & 0xBB) << 8);           // upper size get
            readPacketStruct->size |= (cebf746_master.spi->write(0) & 0xBB);                  // lower size get
            if(0 >= readPacketStruct->size || 20 <= readPacketStruct->size)
                return -1;
            //printf("size : %d\n",readPacketStruct->size );
            for(int iCnt = 0 ; iCnt < readPacketStruct->size ; ++iCnt)                          // packet get
            {
                //wait_us(10);
                *((readPacketStruct->buf) + iCnt) = (uint8_t)cebf746_master.spi->write(0);
            }
            
            readPacketStruct->crc16 = ((cebf746_master.spi->write(0) & 0xFF) << 8);          // upper crc get
            readPacketStruct->crc16 |= (cebf746_master.spi->write(0) & 0xFF);                 // lower crc get
            spi_master_end(&cebf746_master);
            // ---- SPI End
            
            cebf746_print_packet(readPacketStruct);
            
            
            
        break;  /* FUNC_READ_ENC_DATA */
        
        case FUNC_READ_DEC_DATA:    /* FUNC_READ_DEC_DATA */
            printf("FUNC_READ_DEC_DATA:\n");
            memset(readPacketStruct->buf, 0, readPacketStruct->size);
            readPacketStruct->size = 0;
            readPacketStruct->crc16 = 0;

            // ---- SPI Start
            spi_master_start(&cebf746_master);
            cebf746_cmd_write(FUNC_READ_DEC_DATA);
            //SPI_WAIT(500);


            readPacketStruct->size = ((cebf746_master.spi->write(0) & 0xBB) << 8);           // upper size get
            readPacketStruct->size |= (cebf746_master.spi->write(0) & 0xBB);                  // lower size get
            if(0 >= readPacketStruct->size || 20 <= readPacketStruct->size)
            {
                printf("예상 패킷 사이즈가 다릅니다. [%d]\n", readPacketStruct->size);
                return -1;
            }
            //printf("size : %d\n",readPacketStruct->size );
            for(int iCnt = 0 ; iCnt < readPacketStruct->size ; ++iCnt)                          // packet get
            {
                //wait_us(10);
                *((readPacketStruct->buf) + iCnt) = (uint8_t)cebf746_master.spi->write(0);
            }

            readPacketStruct->crc16 = ((cebf746_master.spi->write(0) & 0xFF) << 8);          // upper crc get
            readPacketStruct->crc16 |= (cebf746_master.spi->write(0) & 0xFF);                 // lower crc get
            spi_master_end(&cebf746_master);
            // ---- SPI End

            cebf746_print_packet(readPacketStruct);
        break;  /* FUNC_READ_DEC_DATA */
        







        case FUNC_READ_SELF_TEST:   /* FUNC_READ_SELF_TEST */
            printf("FUNC_READ_SELF_TEST:\n");
            
            memset(readPacketStruct->buf, 0, readPacketStruct->size);
                        
            readPacketStruct->size = 0;
            readPacketStruct->crc16 = 0;
            
            // ---- SPI Start
            spi_master_start(&cebf746_master);                          
            cebf746_cmd_write(FUNC_READ_SELF_TEST);


            readPacketStruct->size = ((cebf746_master.spi->write(0) & 0xBB) << 8);           // upper size get
            readPacketStruct->size |= (cebf746_master.spi->write(0) & 0xBB);                  // lower size get
            
            for(int iCnt = 0 ; iCnt < readPacketStruct->size ; ++iCnt)                          // packet get
            {
                *((readPacketStruct->buf) + iCnt) = (uint8_t)cebf746_master.spi->write(0);
            }
            
            readPacketStruct->crc16 = ((cebf746_master.spi->write(0) & 0xFF) << 8);          // upper crc get
            readPacketStruct->crc16 |= (cebf746_master.spi->write(0) & 0xFF);                 // lower crc get
            spi_master_end(&cebf746_master);
            // ---- SPI End
            
            
            printf("[INFO] CEBF746 Read Self Test : ");
            cebf746_selfTest_packet_compare(readSelfTestValidateData, readPacketStruct);

            cebf746_print_packet(readPacketStruct);
        break; /* FUNC_READ_SELF_TEST */
        
        default :
        ret = -1;
        printf("[ERROR] cebf746_packet_read();\n");
        printf("[ERROR] unknown command code=[%d]\n", cebf746_command);
        return ret;        
    }
    
    
    return ret;
}

void cebf746_set_packet(spiDataStr* setSpiDataStr, uint16_t size, uint8_t * buf)
{
    setSpiDataStr->size = size;
    setSpiDataStr->buf = buf;
    cube_crc_16(setSpiDataStr->size, setSpiDataStr->buf, &setSpiDataStr->crc16);
}

void _cebf746_print_packet(uint16_t size, uint8_t* buf, uint16_t crc16)
{
    printf("--------- cebf746_print_packet -----------\n");
    printf("size : [%d]\n", size);
    printf("data : ");
    for(int i=0;i<size;i++)
    {
        printf("%02X", buf[i]);
    }
    printf("\n");
    
    printf("crc : [%04X]\n", crc16);
    printf("------------------------------------------\n");
}


void cebf746_print_packet(spiDataStr* in)
{
    _cebf746_print_packet(in->size, in->buf, in->crc16);
}
