#include "mbed.h"

#define DEBUG_SPI

#ifdef DEBUG_SPI
#define PRINTD(arg1,arg2...)    printf(arg1,##arg2)
#endif


#define SPI_MOSI    PA_7
#define SPI_MISO    PA_6
#define SPI_SCLK    PA_5
#define SPI_SSEL    PA_4

SPI spi_master(SPI_MOSI,SPI_MISO,SPI_SCLK); // MOSI, MISO, SCLK(CLK,SCK)
DigitalOut cs(SPI_SSEL);

Serial pc_serial(USBTX, USBRX);


void SPI_INIT()
{
    PRINTD("Set SPI init..\n");
    PRINTD("Set SPI format..\n");
    spi_master.format(8,0);
    PRINTD("Set frequency to default..\n");
    spi_master.frequency(1000000); // default 1MHz
}
/*
void SPI_Write()
{
    char temp;
    int i,value;
    char response;
    char tx_cnt = -1;
    char rx_cnt = -1;
    char tx_buffer[255]={0};
    char rx_buffer[255]={0};
    PRINTD("\n==========MASTER==========\n");
    PRINTD("DATA SEND START...\n");
    PRINTD("Lock SPI BUS..\n");

    while(1)
    {
        
        temp=getchar();
        tx_buffer[++tx_cnt]=temp;
        if(temp==0x0d)
        {
            tx_buffer[tx_cnt]=0;
            PRINTD("\nData send Finish...\n");
            for(i=0;i<=tx_cnt;++i)
            {
                PRINTD("%c[%02x]",tx_buffer[i],tx_buffer[i]);
            }
            PRINTD("\n\n");
            spi_master.lock();
            for(i=0;i<=tx_cnt;++i)
            {
                value=tx_buffer[i];
                PRINTD("[M]write[%d]=%c[%02x]\n",i,value,value);
                cs=0;
                response=spi_master.write(value);
                cs=-1;
                PRINTD("[M]receive=%c[%x]\n",response,response);
                rx_buffer[++rx_cnt]=response;
            }
            spi_master.unlock();
            for(i=0;i<255;++i)
            {
                tx_buffer[i]=0;
            }
            for(i=0;i<=tx_cnt;i++)
            {
                PRINTD("init_tx_buffer[%d]=%c\n",i,tx_buffer[i]);
            }
            tx_cnt=-1;
        }
        else
        {
            PRINTD("%c[%02x]",tx_buffer[tx_cnt],tx_buffer[tx_cnt]);
        }
    }
}
*/


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ main();
int main()
{
     int spiTxCnt = 0;     
     char spiTxReadyFlag = 0;
     
     char serialRxBuf[255];
     int serialRxLen = 0;
     
     pc_serial.printf("\n\n========== KSS SPI Master [Start] ==========\n");
     
     
     while(1)
     {        
        if(0 != pc_serial.readable())       // wait serial input..
        {   
            pc_serial.scanf("%s", serialRxBuf);
            serialRxLen = strlen(serialRxBuf);
            pc_serial.printf("len=[%d] %s\n", serialRxLen, serialRxBuf);
            spiTxReadyFlag = 1;
        }        
        if(1 == spiTxReadyFlag)
        {
            // SPI Send Start
            spi_master.lock();            
            cs = 0;   
            for(spiTxCnt = 0 ; spiTxCnt < serialRxLen + 1 ; ++spiTxCnt)
            {
                //printf("send Cnt[%d] [0x%02X]\n", spiTxCnt, serialRxBuf[spiTxCnt]);                         
                spi_master.write(serialRxBuf[spiTxCnt]);    
            }   
            cs = 1;         
            spi_master.unlock();
            spiTxReadyFlag = 0;
        }
        
        
        
        /* TODO " ----(SPI)-----> master --> serial "
        
        */
        
     }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
#if 0   // 161005_BDK_backup2 start
    int send_data;
    SPI_INIT();   
    while(1)
    {
        SPI_Write();   
    }
#endif  // 161005_BDK_backup2 end
    return 0;
}
