// firmware for NUCLEO-F746ZG
// ======== SPI Master Pin
// PA5  - SCK
// PA6  - MISO
// PA7  - MOSI
// PA14 - SEL

#include "mbed.h"
#include "lib_CEBF746.h"
#include "lib_crc.h"

#define DEBUG_SPI
#ifdef DEBUG_SPI
#define PRINTD(arg1,arg2...)    printf(arg1,##arg2)
#endif

// ======== SPI Func define
#define EEPROM_WREN         0x06        // Write Enable
#define EEPROM_WRDI         0x04        // Write Disable
#define EEPROM_RDSR         0x05        // Read Status Register
#define EEPROM_WRSR         0x01        // Write Status Register
#define EEPROM_READ         0x03        // Read EEPROM Memory
#define EEPROM_WRITE        0x02        // Write EEPROM Memory
#define EEPROM_MULTIREAD    0x07        // Write EEPROM Memory

#define SPI_CONFIG_BIT          8
#define SPI_CONFIG_FREQUENCY    1000000         // 1Mhz
//#define SPI_CONFIG_FREQUENCY    50000000      // 50Mhz



Serial pc_serial(USBTX, USBRX);

typedef enum
{
    MENU_READ_STATUS_REG = 1,
    MENU_SPI_SELF_TEST_WRITE = 2,
    MENU_SPI_SELF_TEST_READ = 3,
    MENU_SPI_WRITE_ENC_DATA = 4,
    MENU_SPI_READ_ENC_DATA = 5,
    
    MENU_EXIT_Program = 9
}cebf746_command;

/** @brief print menu
 *
 */
void print_menu(void)
{
    pc_serial.printf("\n\n\n");
    pc_serial.printf("-----------[CEBF746 Test MENU]----------\n");
// CEBF746 func ###
    
    
    pc_serial.printf("%d) Read Status Reg\n", MENU_READ_STATUS_REG);
    pc_serial.printf("%d) Self Test(Write)\n", MENU_SPI_SELF_TEST_WRITE);
    pc_serial.printf("%d) Self Test(Read)\n", MENU_SPI_SELF_TEST_READ);
    pc_serial.printf("%d) Encrypt Data Write(16Byte)\n", MENU_SPI_WRITE_ENC_DATA);
    pc_serial.printf("%d) Encrypted Data Read(16Byte)\n", MENU_SPI_READ_ENC_DATA);
// cubebite test func ###


// exit func ###
    pc_serial.printf("%d) Exit program\n", MENU_EXIT_Program);
    pc_serial.printf("----------------------------------------\n");
    pc_serial.printf("input menu : ");
}


/** @brief convert ASCII to hex
 *
 *  @param convertedData converted Data
 *  @param sourceBuf ASCII data array
 *  @param lenght sourceBuf length
 *  @return 0 is valid hex format, other is error
 */
int converHex(char * convertedData, char * sourceBuf, int length)
{
    int ret = 0;
    char tempBuf[length];
    *convertedData = 0;

    for (int iCnt = 0; iCnt < length; iCnt++)
    {
        if (('0' <= *(sourceBuf + iCnt)) && ('9' >= *(sourceBuf + iCnt)))
        {
            tempBuf[iCnt] = (*(sourceBuf + iCnt) - 48);
        }
        else if (('A' <= *(sourceBuf + iCnt)) && ('F' >= *(sourceBuf + iCnt)))
        {
            tempBuf[iCnt] = (*(sourceBuf + iCnt) - 55);
        }
        else if (('a' <= *(sourceBuf + iCnt)) && ('f' >= *(sourceBuf + iCnt)))
        {
            tempBuf[iCnt] = (*(sourceBuf + iCnt) - 87);
        }
        else    // error
        {
            ret = -1;
            return ret;
        }
    }

    //pc_serial.printf("[TEST] tempBuf[0] = 0x%02X\n", tempBuf[0]);
    //pc_serial.printf("[TEST] tempBuf[1] = 0x%02X\n", tempBuf[1]);
    *convertedData = ((tempBuf[0] & 0x0F) << 4) | (tempBuf[1] & 0x0F);
    //pc_serial.printf("[TEST] convertedData = 0x%02X\n", *convertedData);
    return ret;
}







/** @brief main function ###################################################################
 *
 */
int main()
{
    uint16_t tempCrc;
    char ret = 0;
    char retCode;
    char inputMenuNum = 0;
    spiDataStr sendData;
    spiDataStr reciveData;
    
    uint8_t encTempBuf[CEB_BUF_SIZE] = {0, };            
    
    uint8_t spiMOSIBuf[255];
    uint8_t spiMISOBuf[255];
    

    
    cebf746_use_init();

    pc_serial.printf("\n\n========== SPI Master for CEBF746 [Start] ==========\n");

    while (1)
    {
        print_menu();
        inputMenuNum = pc_serial.getc();

        pc_serial.printf("[DEBUG] input menu number = %c\n", inputMenuNum);

        if (('0' < inputMenuNum) && ('9' >= inputMenuNum))
        {
            inputMenuNum = inputMenuNum - 48;
        }
        else
        {
            pc_serial.printf("[INFO] correct input menu number.. please retry..\n");
            wait(1);
            continue;
        }





        memset(spiMISOBuf, 0, 255);
        memset(spiMOSIBuf, 0, 255);
        retCode = 0xFF;
        switch (inputMenuNum)
        {
        
        case MENU_READ_STATUS_REG:        // Write Enable =================================[OK]
            pc_serial.printf("[DEBUG] Read Status Reg..\n");
            ret = 0;
            ret = cebf746_packet_read(FUNC_READ_STATUS, 0);
            printf("[INFO] status reg [%02X]\n", ret);
            break;
            
            
        case MENU_SPI_SELF_TEST_WRITE:         // 161017_KSS_Test OK
            char spiSelfTestBuf[CEB_BUF_SIZE] = WRITE_SELF_TEST_DATA;
                       
            sendData.size = sizeof(spiSelfTestBuf);
            sendData.buf = (uint8_t*)spiSelfTestBuf;
            sendData.crc16 = 0;

            ret = cebf746_packet_write(FUNC_WRITE_SELF_TEST, &sendData);
/*
            cebf746_print_packet(&sendData);
            
            pc_serial.printf("FUNC_WRITE_SELF_TEST..");
            if(0 == ret)
            {
                pc_serial.printf("[SUCESS] ret = %02X\n", ret);
            }
            else
            {
                pc_serial.printf("[FAIL] ******** ret = %02X ******** \n", ret);
            }            
*/
            break;
            
        case MENU_SPI_SELF_TEST_READ:         // 161017_KSS_Test OK            
            char selfTempRxBuf[CEB_BUF_SIZE]={0,};
            
            reciveData.size = CEB_BUF_SIZE;
            reciveData.buf = (uint8_t*)selfTempRxBuf;
            reciveData.crc16 = 0;
            
            ret = cebf746_packet_read(FUNC_READ_SELF_TEST, &reciveData);
            
            break;
        
        
        case MENU_SPI_WRITE_ENC_DATA:               //  Master >>>>>(encrypt data)>>>>> Slave
            
            
            pc_serial.printf("input Encrypt String (16 character) : ");
            for(int iCnt = 0 ; iCnt < 16 ; ++iCnt)                
            {   
                encTempBuf[iCnt] = pc_serial.getc();    
                pc_serial.printf("%c", encTempBuf[iCnt]); 
            }
                    
            sendData.size = sizeof(encTempBuf);
            sendData.buf = (uint8_t*)encTempBuf;
            sendData.crc16 = 0;
            
            ret = cebf746_packet_write(FUNC_WRITE_ENC_DATA, &sendData);
            
            break;
            
            
        case MENU_SPI_READ_ENC_DATA:                //  Master <<<<<(encrypted data)<<<<< Slave  
            int encryptWaitCnt = 10;
            
            // ★★★★ status reg 읽어오는 부분이 문제가 있는듯함 여기를 먼저 고쳐야함 
            while(1)
            {
                ret = cebf746_packet_read(FUNC_READ_STATUS, 0);
                if(ret == 0x02)       // Encrypting..                
                {
                    --encryptWaitCnt;       
                    if(0 >= encryptWaitCnt)
                        break;
                }
                else
                {
                    break;
                }
            }
            
            
            if(0 == encryptWaitCnt)
            {                
                printf("[INFO] The CEBF746 is running, STATUS[%02X]\n", ret);
                continue;
            }
            else
            {
                /* 161019_암호화된 데이터 읽어와야함. 슬레이브도 구현 해야함 */
                reciveData.size = sizeof(encTempBuf)+2;
                reciveData.buf = (uint8_t*)encTempBuf;
                reciveData.crc16 = 0;
              
                ret = cebf746_packet_read(FUNC_READ_ENC_DATA, &reciveData);
                
                printf("[DEBUF]MENU_SPI_READ_ENC_DATA return [%02X]\n", ret);
            }
            
            
            
        /*       
            uint8_t encTempBuf[CEB_BUF_SIZE] = {0, };            
            
            pc_serial.printf("input Encrypt String (16 character) : ");
            for(int iCnt = 0 ; iCnt < 16 ; ++iCnt)                
            {   
                encTempBuf[iCnt] = pc_serial.getc();    
                pc_serial.printf("%c", encTempBuf[iCnt]); 
            }
                    
            sendData.size = sizeof(encTempBuf);
            sendData.buf = (uint8_t*)encTempBuf;
            sendData.crc16 = 0;
            
            ret = cebf746_packet_write(FUNC_WRITE_ENC_DATA, &sendData);
          */  
            break;


        case MENU_EXIT_Program:
            
            pc_serial.printf("exit program... thank you\n");
            //return 0;

        }
        

    }

    return 0;
}
