#include "mbed.h"

#define DEBUG_SPI

#ifdef DEBUG_SPI
#define PRINTD(arg1,arg2...)    printf(arg1,##arg2)
#endif


#define SPI_MOSI    PA_7
#define SPI_MISO    PA_6
#define SPI_SCLK    PA_5
#define SPI_SSEL    PA_4


SPISlave spi_slave(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_SSEL); // MOSI, MISO, SCLK(CLK), SSEL(CS)=NC
Serial pc_serial(USBTX, USBRX);

void SPI_SlaveInit()
{
    PRINTD("Set the SPI SLAVE format\n");
    spi_slave.format(8,0); // setup 8bit 0 mode
    PRINTD("Set the SPI SLAVE frequency\n");
    spi_slave.frequency(); // default 1MHz
}

void SPI_SlaveWrite()
{
    char tx_buffer[255]={0};
    char reply;
    char i;
    char temp;
    char tx_cnt = 0;
    int value;
    PRINTD("Input Strging=");
    while(1)
    {
        
        temp=getchar();
        tx_buffer[tx_cnt++]=temp;
        if(temp==0x0d)
        {
            tx_buffer[tx_cnt]=0;
            PRINTD("\nData send Finish...\n");
            for(i=0;i<=tx_cnt;++i)
            {
                PRINTD("%c[%02x]",tx_buffer[i],tx_buffer[i]);
            }
            PRINTD("\n\n");
            for(i=0;i<=tx_cnt;++i)
            {
                value=tx_buffer[i];
                PRINTD("write[%d]=%c[%02x]\n",i,value,value);
                spi_slave.reply(value);
            }
            for(i=0;i<tx_cnt;++i)
            {
                tx_buffer[i]=0;
                PRINTD("init_tx_buf[%d]=%c\n",i,tx_buffer[i]);
            }
            tx_cnt=0;
            PRINTD("break\n");
            break;
        }
        else
        {
            PRINTD("%c[%02x]",tx_buffer[tx_cnt],tx_buffer[tx_cnt]);
        }
    }
    return;
}

int main()
{
    char serialTxReadyFlag = 0;
    int spiRxTempBuf = 0;
    char spiRxBuf[255];
    int spiRxTempCnt = 0;
    int spiRxLen = 0;
    
    
    int spiTxCnt = 0;    
    char spiTxReadyFlag = 0;
    
    char serialRxBuf[255];
    int serialRxLen = 0;
    
    SPI_SlaveInit();
    spi_slave.reply(0x00);     // Prime SPI with first reply

    
    pc_serial.printf("\n\n========== KSS SPI Slave [Start] ==========\n");
    
    while(1)
    {
        if(spi_slave.receive())     // wait SPI data input...
        {            
            spiRxTempBuf = spi_slave.read();
            spiRxBuf[spiRxTempCnt++] = spiRxTempBuf;
            
            if(0x00 == spiRxTempBuf)
            {                
                serialTxReadyFlag = 1;                
                //pc_serial.printf("SPI Recive Byte [%d]\n", spiRxTempCnt-1);
                spiRxLen = strlen(spiRxBuf);
                spiRxTempCnt = 0;
            }
        }
        if(1 == serialTxReadyFlag)
        {
            serialTxReadyFlag = 0;
            pc_serial.printf("len=[%d] %s\n", spiRxLen, spiRxBuf);
        }
        
        
        
        
        /* TODO "serial -> slave ----(SPI)-----> " */
        
        if(0 != pc_serial.readable())       // wait serial input..
        {   
            pc_serial.scanf("%s", serialRxBuf);
            serialRxLen = strlen(serialRxBuf);
            pc_serial.printf("len=[%d] %s\n", serialRxLen, serialRxBuf);
            spiTxReadyFlag = 1;
        }        
        if(1 == spiTxReadyFlag)
        {
            PRINTD("spiTxReadyFlag=%d\n",spiTxReadyFlag);
            // SPI Send Start
            
#if 0
            for(spiTxCnt = 0 ; spiTxCnt < serialRxLen + 1 ; ++spiTxCnt)
            {
                //printf("send Cnt[%d] [0x%02X]\n", spiTxCnt, serialRxBuf[spiTxCnt]);                         
                spi_slave.reply(serialRxBuf[spiTxCnt]);    
            } 
#endif        
            for(spiTxCnt = 0 ; spiTxCnt < 1 ; ++spiTxCnt)
            {
                //printf("send Cnt[%d] [0x%02X]\n", spiTxCnt, serialRxBuf[spiTxCnt]);
                
                spi_slave.reply(serialRxBuf[spiTxCnt]);    
                PRINTD("reply=%c\n",serialRxBuf[spiTxCnt]);
            }  
            
            
            spiTxReadyFlag = 0;
            PRINTD("spiTxReadyFlag =0\n");
        }
        
     
        
        
        
        
        
        
        
    }
    
    
    
    
    
    
    
    
    
#if 0   // 161005_BDK_slave backup start
    int i;
    char valueFromMaster;
    char rx_buffer[255]={0};
    char rx_cnt = -1;
    PRINTD("\n=========SLAVE=========\n");
    SPI_SlaveInit();
    
    while(1)
    {

        if(spi_slave.receive())
        { 
            PRINTD("----1\n");
            if(pc.readable())
            {
                SPI_SlaveWrite();
            }
            PRINTD("----2\n");
            valueFromMaster = spi_slave.read();
            PRINTD("----3\n");
            //PRINTD("valueFromMaster=");
            //PRINTD("[%c]%x\n",valueFromMaster,valueFromMaster);
            rx_buffer[++rx_cnt]=valueFromMaster;
            if(valueFromMaster==0)
            {   
                PRINTD("rx_string=");
                for(i=0;i<rx_cnt;i++) 
                {    
                    PRINTD("%c",rx_buffer[i]);
                }
                PRINTD("\n");
                for(i=0;i<=rx_cnt;i++)
                {
                    rx_buffer[i]=0;
                    PRINTD("Init_rx_buf[%d]=%c\n",i,rx_buffer[i]);
                }
                rx_cnt=-1;
               
            }//valueFromMaster if
            
        }// spi_slave.receive() if
     /*
                
            */
    }//end of while
#endif  // 161005_BDK_slave backup end
}//end of main
