#include "mbed.h"

#define DEBUG_SPI

#ifdef DEBUG_SPI
#define PRINTD(arg1,arg2...)    printf(arg1,##arg2)
#endif


#define SPI_MOSI    PA_7
#define SPI_MISO    PA_6
#define SPI_SCLK    PA_5
#define SPI_SSEL    PA_4

#define EEPROM_WREN     0x06        // Write Enable
#define EEPROM_WRDI     0x04        // Write Disable
#define EEPROM_RDSR     0x05        // Read Status Register
#define EEPROM_WRSR     0x01        // Write Status Register
#define EEPROM_READ     0x03        // Read EEPROM Memory
#define EEPROM_WRITE    0x02        // Write EEPROM Memory
#define EEPROM_MULTIREAD    0x07        // Read Multibyte EEPROM Memory

SPISlave spi_slave(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_SSEL); // MOSI, MISO, SCLK(CLK), SSEL(CS)=NC
Serial pc_serial(USBTX, USBRX);

void SPI_SlaveInit()
{
    PRINTD("Set the SPI SLAVE format\n");
    spi_slave.format(8,0); // setup 8bit 0 mode
    PRINTD("Set the SPI SLAVE frequency\n");
    //spi_slave.frequency(50000000); // default 1MHz
    spi_slave.frequency(1000000);
}

void SPI_SlaveWrite()
{
    char tx_buffer[255]={0};
    char reply;
    char i;
    char temp;
    char tx_cnt = 0;
    int value;
    PRINTD("Input Strging=");
    while(1)
    {
        
        temp=getchar();
        tx_buffer[tx_cnt++]=temp;
        if(temp==0x0d)
        {
            tx_buffer[tx_cnt]=0;
            PRINTD("\nData send Finish...\n");
            for(i=0;i<=tx_cnt;++i)
            {
                PRINTD("%c[%02x]",tx_buffer[i],tx_buffer[i]);
            }
            PRINTD("\n\n");
            for(i=0;i<=tx_cnt;++i)
            {
                value=tx_buffer[i];
                PRINTD("write[%d]=%c[%02x]\n",i,value,value);
                spi_slave.reply(value);
            }
            for(i=0;i<tx_cnt;++i)
            {
                tx_buffer[i]=0;
                PRINTD("init_tx_buf[%d]=%c\n",i,tx_buffer[i]);
            }
            tx_cnt=0;
            PRINTD("break\n");
            break;
        }
        else
        {
            PRINTD("%c[%02x]",tx_buffer[tx_cnt],tx_buffer[tx_cnt]);
        }
    }
    return;
}

void spi_dummy_reply(void)
{
    spi_slave.reply( 0xA0 );
}

#define EEPROM_SIZE 256
char statusReg;
char eepBuf[EEPROM_SIZE];

void printBuf(char * buf, int length)
{
    pc_serial.printf("=======================[EEPROM]========================\n");
    pc_serial.printf("      |");
    for(int iCnt = 0 ; iCnt < 16 ; ++iCnt)
    {
        pc_serial.printf("%02X|", iCnt);
    }
    pc_serial.printf("\n");
    
    
    for(int iCnt = 0 ; iCnt < length ; ++iCnt)
    {
        if(0 == ((iCnt) % 16))
        {
            pc_serial.printf("[0x%02X] ", iCnt);
        }
        
        pc_serial.printf("%02X ", *(buf + iCnt));
        
        if(0 == ((iCnt+1) % 16))
        {
            pc_serial.printf("\n");
            
        }
        
    }
    pc_serial.printf("=======================================================\n");
}

int main()
{

    char spiMulti = 0;    
    char eepAddr = 0;     
    char eepData = 0;

    char serialTxReadyFlag = 0;
    int spiRxTempBuf = 0;
    char spiRxBuf[255];
    int spiRxTempCnt = 0;
    int spiRxLen = 0;
    
    
    int spiTxCnt = 0;    
    char spiTxReadyFlag = 0;
    
    char serialRxBuf[255];
    int serialRxLen = 0;
    
    SPI_SlaveInit();
    
    /*
    NVIC_SetVector( SPI_IRQn , ( uint32_t ) executa_spi_slave_hw ) ;
    NVIC_SetPriority( SPI_IRQn , 2 ) ;
    NVIC_EnableIRQ( SPI_IRQn ) ;
    */

    
    pc_serial.printf("\n\n========== KSS SPI Slave2 [Start] ==========\n");
    
    while(1)
    {
        if(spi_slave.receive())     // wait SPI data input...
        {            
            spiRxTempBuf = spi_slave.read();
            //spi_slave.reply( statusReg++ );
            //continue;
            
            switch(spiRxTempBuf)
            {
                case EEPROM_WREN:
                    //spi_dummy_reply();
                    pc_serial.printf("[INFO] SPI_MOSI(RX) : WREN\n"); 
                    statusReg = statusReg | (1<<1) ;
                    pc_serial.printf("[INFO] WREN sucess [0x%02X]\n", statusReg);                     
                break;
                
                case EEPROM_WRDI:
                    //spi_dummy_reply();
                    pc_serial.printf("[INFO] SPI_MOSI(RX) : WRDI\n"); 
                    statusReg = statusReg & (~(1 << 1)) ;
                    pc_serial.printf("[INFO] WRDI sucess [0x%02X]\n", statusReg);                     
                break;

                case EEPROM_RDSR:
                    spi_slave.reply( statusReg );                    
                    pc_serial.printf("[INFO] SPI_MOSI(RX) : RDSR\n");                     
                    pc_serial.printf("[INFO] SPI_MISO(TX) : RDSR[0x%02X] \n", statusReg); 
                break;
                
                
                case EEPROM_WRITE:
                    // EEPROM Address read..
                    while(!spi_slave.receive());     
                    eepAddr = spi_slave.read();
                    
                    // EEPROM Data read..
                    while(!spi_slave.receive());     
                    eepData = spi_slave.read();
                    
                    pc_serial.printf("\n[DEBUG] Addr[0x%02X] Data[0x%02X] \n", eepAddr, eepData);    
                    
                    if(statusReg & 0x02)
                    {
                        statusReg |= 0x01;
                        eepBuf[eepAddr] = eepData;
                        printBuf(eepBuf, EEPROM_SIZE);           
                        statusReg &= (~0x01);
                        
                    }
                    else
                    {
                        pc_serial.printf("\nwrite command is disabled\n");        
                    }                    
                break;
                
                
                case EEPROM_READ:
                    // EEPROM Address read..
                    while(!spi_slave.receive());     
                    eepAddr = spi_slave.read();
                    
                    spi_slave.reply( eepBuf[eepAddr] );
                    
                    pc_serial.printf("\n[DEBUG] Addr[0x%02X]\n", eepAddr); 
                    
                    
                    
                    
                break;
                
                
                case  EEPROM_MULTIREAD:
                    // EEPROM_MULTIREAD..
                    while(!spi_slave.receive());
                    eepAddr = spi_slave.read();
                    printf("[DEBUG] [M to S] eepAddr=0x%02x\n",eepAddr++);
                    //printf("[DEBUG] [M to S] eepAddr=0x%02x\n",eepAddr);
                    for(int i=0;i<7;i++)
                    {
                        //spi_slave.reply( eepBuf[eepAddr] );
                        spi_slave.reply( i );
                        //++eepAddr;
                        //printf("[0x%02x] ",spiMulti);
                        pc_serial.printf("."); 
                        
                    }
                    pc_serial.printf("\n"); 
                break;
                
                
                default:
                //spi_dummy_reply();
            }
            
            //pc_serial.printf("------------------------ end SPI Communication\n"); 
            
        }
    }
    
    
    
    
    
    
    
    
            
            
            /*
            spiRxBuf[spiRxTempCnt++] = spiRxTempBuf;
            
            if(0x00 == spiRxTempBuf)
            {                
                serialTxReadyFlag = 1;                
                //pc_serial.printf("SPI Recive Byte [%d]\n", spiRxTempCnt-1);
                spiRxLen = strlen(spiRxBuf);
                spiRxTempCnt = 0;
            }
            
        }
        if(1 == serialTxReadyFlag)
        {
            serialTxReadyFlag = 0;
            pc_serial.printf("SPI_RX Data : len=[%d] %s\n", spiRxLen, spiRxBuf);
        }
        
        */
        
        
        
#if 0        
        /* TODO "serial -> slave ----(SPI)-----> " */
        
        if(0 != pc_serial.readable())       // wait serial input..
        {   
            pc_serial.scanf("%s", serialRxBuf);
            serialRxLen = strlen(serialRxBuf);
            pc_serial.printf("len=[%d] %s\n", serialRxLen, serialRxBuf);
            spiTxReadyFlag = 1;
        }        
        if(1 == spiTxReadyFlag)
        {
            PRINTD("spiTxReadyFlag=%d\n",spiTxReadyFlag);
            // SPI Send Start
            

            for(spiTxCnt = 0 ; spiTxCnt < serialRxLen + 1 ; ++spiTxCnt)
            {
                //printf("send Cnt[%d] [0x%02X]\n", spiTxCnt, serialRxBuf[spiTxCnt]);                         
                spi_slave.reply(serialRxBuf[spiTxCnt]);    
            } 

            for(spiTxCnt = 0 ; spiTxCnt < 1 ; ++spiTxCnt)
            {
                //printf("send Cnt[%d] [0x%02X]\n", spiTxCnt, serialRxBuf[spiTxCnt]);
                
                spi_slave.reply(serialRxBuf[spiTxCnt]);    
                PRINTD("reply=%c\n",serialRxBuf[spiTxCnt]);
            }  
            
            
            spiTxReadyFlag = 0;
            PRINTD("spiTxReadyFlag =0\n");
        }
#endif                
     
        
    
    
    
#if 0   // 161005_BDK_slave backup start
    int i;
    char valueFromMaster;
    char rx_buffer[255]={0};
    char rx_cnt = -1;
    PRINTD("\n=========SLAVE=========\n");
    SPI_SlaveInit();
    
    while(1)
    {

        if(spi_slave.receive())
        { 
            PRINTD("----1\n");
            if(pc.readable())
            {
                SPI_SlaveWrite();
            }
            PRINTD("----2\n");
            valueFromMaster = spi_slave.read();
            PRINTD("----3\n");
            //PRINTD("valueFromMaster=");
            //PRINTD("[%c]%x\n",valueFromMaster,valueFromMaster);
            rx_buffer[++rx_cnt]=valueFromMaster;
            if(valueFromMaster==0)
            {   
                PRINTD("rx_string=");
                for(i=0;i<rx_cnt;i++) 
                {    
                    PRINTD("%c",rx_buffer[i]);
                }
                PRINTD("\n");
                for(i=0;i<=rx_cnt;i++)
                {
                    rx_buffer[i]=0;
                    PRINTD("Init_rx_buf[%d]=%c\n",i,rx_buffer[i]);
                }
                rx_cnt=-1;
               
            }//valueFromMaster if
            
        }// spi_slave.receive() if
     /*
                
            */
    }//end of while
#endif  // 161005_BDK_slave backup end
}//end of main
