#include "mbed.h" // import of mbed library (required)
/*******************************************************************************

  EXAMPLE DESCRIPTION

  Uses two buttons connected to PA_0 - plus and PA_1 - minus with internal pull 
  up resistors. On PA_8 is PWM output with variable duty cycle (DC) and frequncy 
  of 500 Hz.DC can be changed true buttons. On press of button DC is incremented 
  or decremented by 0.01. Interrupt is attached to falling edge on appropriate
  pin and process of incrementation/decrementation is driven throu this
  interrupt. Programm also demonstrates auto incrementation/decrementation while
  button is pressed for longer than 1 s. After button is pressed timer is 
  started. Ticker periodically  (every 10 ms) calls function that checks timer
  value. If the timer had counted more than 1 s, It is stopped and auto 
  incementation/decrementation is stared (+-0.01 every 500 ms). After button
  release auto incementation/decrementation is stopped and timer reset. 
  Programm is written in way, that there can NOT be simultaneously active both
  auto incrementation and decrementation. Note that there are also prints to 
  UART to check states of buttons and change of DC.
  
*******************************************************************************/

InterruptIn buttonPlus(PA_0); // deffition of interrupt
InterruptIn buttonMinus(PA_1); // deffition of interrupt

PwmOut PWM(PA_8); // definition of PWM pin

Timer tim; // Timer definition

Ticker tick; // Ticker definition

bool autoIncrement=false; // true - do autoincrement
                          // false - do not autoincrement

bool plus=true; // true -  auto increment
                // false - auto decrement

// called after falling edge on PA_0
// starts timer for auto increment check
// increments DC
void pressedPlus() {
    tim.start(); // start Timer
    plus=true; // incrementation
    if (PWM.read()+0.01 <= 1) {
        PWM.write(PWM.read()+0.01); 
        printf("Presed plus button. DC: %f.\n",PWM.read());
    }else{
        PWM.write(1);
        printf("Presed plus button. Already maximum DC.\n");
    }
}

// called after rising edge on PA_0
// stops and resets auto increment timer
// stops auto increment
void releasedPlus(){
    tim.stop();
    tim.reset();
    autoIncrement=false;
    printf("Plus button released.\n");
}

// called after falling edge on PA_1
// starts timer for auto decrement check
// decrements DC
void pressedMinus() {
    tim.start(); // start Timer
    plus=false; // decrementation
    if (PWM.read()-0.01 >= 0) {
        PWM.write(PWM.read()-0.01);
        printf("Presed minus button. DC: %f\n",PWM.read());
    }else{
        PWM.write(0);
        printf("Presed minus button. Already minimum DC.\n");
    }
}

// called after rising edge on PA_1
// stops and resets auto decrement timer
// stops auto decrement
void releasedMinus(){
    tim.stop();
    tim.reset();
    autoIncrement=false;
    printf("Minus button released.\n");
}


// checks timer value
// if > 1 s starts auto incerement/decrement
void checkTimer(){
    if(tim.read_ms()>1000){
        tim.stop();
        autoIncrement=true;
    }    
}

int main()
{
        
    // Set PWM
    PWM.period_ms(2); // 500 Hz
    PWM.write(0); // duration of active pulse
    
    // Set buttons interrupts
    buttonPlus.fall(&pressedPlus);
    buttonMinus.fall(&pressedMinus);
    buttonPlus.rise(&releasedPlus);
    buttonMinus.rise(&releasedMinus);
    
    // internal pull ups
    buttonPlus.mode(PullUp);
    buttonMinus.mode(PullUp);
    
    // set ticker interrupt
    tick.attach(&checkTimer,0.01);
    
    while (1) {
        // check if auto increment/decrement
        if(autoIncrement && plus && PWM.read()+0.01 <= 1){
            PWM.write(PWM.read()+0.01);
            printf("Autoincrement. DC: %f.\n",PWM.read());
        }
        else if(autoIncrement && !plus && PWM.read()-0.01 >= 0){
            PWM.write(PWM.read()-0.01);
            printf("Autodecrement. DC: %f.\n",PWM.read());
        }
        wait_ms(500);
    }
}
