#include "mbed.h"

/*******************************************************************************

  EXAMPLE DESCRIPTION
  
  Initialize Timer and Ticker. Timer is started and Ticker then calls funtion
  that prints timer value to UART.
  
*******************************************************************************/

Timer tim; // Timer definition
Ticker tick; // Ticker definition

// returns Timer value
int getTimerVal(Timer *tim) {
    int time = tim->read_us();
    // reset when overflow
    if (time<0){
        tim->reset();
        time = tim->read_us();
    }
    
    return time;
}

// prints Timer value to UART (default UART->USB) Bd 9600, no parity, 1 stopbit
void printTimerVal(){
    printf("Timer is running %i us.\n", getTimerVal(&tim));
}

int main()
{
    tim.start(); // start Timer
    tick.attach(&printTimerVal, 0.1); // Init the ticker with the address of the 
                                   // function to be attached and 
                                   // the interval (100 ms)
    while (true) {
        // main programm loop - can do other things
    }
}
