#include "mbed.h"

/*******************************************************************************

  EXAMPLE DESCRIPTION
  
  Program toggles onboard LED with 1 Hz frequency. It uses timer, which is 
  periodically read (1 ms) and if its value is higher than that of variable the
  LED is toggled. After that variable is incremented so timer has not to be
  reset.
  
*******************************************************************************/

Timer tim; // Timer definition
DigitalOut LED(LED1); // definition of digital out pin

// returns Timer value
int getTimerVal(Timer *tim) {
    int time = tim->read_ms();
    // reset when overflow
    if (time<0){
        tim->reset();
        time = tim->read_ms();
    }
    
    return time;
}


int main()
{
    LED = 0; // turn LED on
    int timeCompare = 500; // time for comparison
    int time; // timer time
    tim.start(); // start Timer
    while (true) {
        time = getTimerVal(&tim); // get timer time
        if(time>timeCompare){
            LED=!LED; // toggle LED
            timeCompare=time+500; // increment time for comparison
        }
        wait_ms(1);
    }
}
