#include "mbed.h"

/*******************************************************************************

  EXAMPLE DESCRIPTION
  
  Initialize ticker that periodically (100 ms) calls function that toggles 
  onboard LED.
  
*******************************************************************************/

Ticker tick; // Ticker definition

DigitalOut LED(LED1);  // definition of digital out pin

// Toggles LED
void toggleLED() {
    LED = !LED;
}

int main() {
    tick.attach(&toggleLED, 0.1); // Init the ticker with the address of the 
                                   // function (toggle_led) to be attached and 
                                   // the interval (100 ms)
    while (true) {
        // main programm loop - can do other things
    }
}