#include "mbed.h" // import of mbed library (required)

/*******************************************************************************

  EXAMPLE DESCRIPTION

  Sets PWM out on pin PA_8 with f=200 Hz. Then changes duty cycle from 0 to 1
  in 500 steps with 4 ms wait (from 0 to 1 in 1 s) and back from 1 to 0. 
  The best use is to connect LED to pin PA_8 (using wiring with transitor) 
  to see effect of PWM.
   
*******************************************************************************/

PwmOut PWM(PA_8); // definition of PWM pin

int main()
{

    PWM.period_ms(5); // period of PWM - f=1/T -> f=1/0.005=200 Hz
    PWM.pulsewidth_us(0); // duration of active pulse
                            //sets duty cycle - duty cycle = pulsewidth/period

    while(1) {
        for(int i=0;i<=5000;i=i+10){
            PWM.pulsewidth_us(i); // increment duty cycle
            wait_ms(2); // wait 4 ms (whole for takes 1 s)
        }
        for(int i=5000;i>=0;i=i-10){
            PWM.pulsewidth_us(i); // decrement duty cycle
            wait_ms(2); // wait 4 ms (whole for takes 1 s)
        }
    }
}
