#include "mbed.h"
/*******************************************************************************

  EXAMPLE DESCRIPTION

  Initialize ADC on pin PA_0 and PWM out on PA_8. Every 1 ms reads voltage on
  PA_0 and converts it to DC of PWM on PA_8 (2 ms period, range 0-2000 us of
  active pulse). The best use is to connect LED to pin PA_8 (using wiring 
  with transitor) to see effect of PWM.
   
*******************************************************************************/

AnalogIn ADCpin(PA_0); // definition of ADC pin
PwmOut PWM(PA_8); // definition of PWM pin

int main()
{
    int DC = 0;

    // set PWM
    PWM.period_ms(2); // 500 Hz
    PWM.pulsewidth_us(DC); // duration of active pulse
    
    while(1) {
        DC= ADCpin.read_u16(); // read voltage on A0
        DC=(DC*2000)/0xffff; // change of range
        PWM.pulsewidth_us(DC); // duration of active pulse
        wait_ms(1); // wait 1 ms
    }
}
