#include "mbed.h"
#include "process_data.h"
#include "SystemTime.h"
#include "debug.h"
#include "MovingAverage.h"
#include "PeakDetector.h"
#include "FloatingThresholdPeakDetector.h"
#include "SimplePeakDetector.h"
#include "main.h"
#include "debug.h"

PeakDetector::PeakDetector *peakDetector;
PeakDetector::PeakDetector *startDetector;
Timer split_timer;

enum SwimState {WAITING, TIMING};
SwimState swimState;

/* Creates a new peak detector */
bool process_init()
{
    swimState = WAITING;
    
    peakDetector = new FloatingThresholdPeakDetector();
    startDetector = new SimplePeakDetector(30, 4000);

    split_timer.reset();
    return true;
}

/* If true, loads latest split time into split  */
bool process_data(int xdata, int ydata, int *split)
{
    static int start_time;
    if (swimState == WAITING) {
        if (startDetector->onPeak(xdata)) {
            swimState = TIMING;
            split_timer.start();
            start_time = SystemTime::read_ms();
            PC_PRINTLNF("xpeak - %d", start_time);
        }
    } else if (swimState == TIMING) {
        // Potential source of overflow if read_ms rolls over
        if (peakDetector->onPeak(ydata) && SystemTime::read_ms() - start_time > 5000 ) {
            PC_PRINTLNF("ypeak - %d", split_timer.read_ms());
            static int i = 0;

            if (++i % 2 == 0) {
                *split = split_timer.read_ms();
                split_timer.reset();
                return true;
            }
        }
    }
    
    return false;
}

bool process_close() {
    split_timer.reset();
    split_timer.stop();
    
    delete peakDetector;
    delete startDetector;
    
    return true;
}