#ifndef _MAIN_H
#define _MAIN_H

#define SYNC_HOLD_TIME_MS 1000
#define DEBOUNCE_TIME_MS 200

#include "Adafruit_SSD1306.h"
#include "DS3231.h"

#define USE_OLED
#ifdef USE_OLED

    extern SPI spi0; // mosi, miso, sclk
    extern Adafruit_SSD1306 oled; // DC, RST, CS

    #define OLED_SETCURS(xpos,ypos) oled.setCursor(xpos,ypos);
    #define OLED_CLEAR() oled.clearDisplay(); oled.display();
    
    #define OLED_DRAWPIXEL(x,y,color) oled.drawPixel(x, y, color); oled.display();
    
    #define OLED_PRINT(x) oled.printf("%s", x); oled.display();
    #define OLED_PRINTF(x,y) oled.printf(x, y); oled.display();
    #define OLED_PRINTLN(x) oled.printf("%s\r\n", x); oled.display();
    #define OLED_PRINTLNF(x,y) oled.printf(x,y); oled.printf("\r\n"); oled.display();
    #define OLED_PRINTR(x) oled.printf("%s\r",x); oled.display();
    #define OLED_PRINTFR(x,y) oled.printf(x,y); oled.printf("\r"); oled.display();

    // Specify position
    #define OLED_PRINTP(x,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf("%s", x); oled.display();
    #define OLED_PRINTPF(x,y,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf(x, y); oled.display();
    #define OLED_PRINTPLN(x,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf("%s\r\n", x); oled.display();
    #define OLED_PRINTPLNF(x,y,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf(x,y); oled.printf("\r\n"); oled.display();
    #define OLED_PRINTPR(x,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf("%s\r",x); oled.display();
    #define OLED_PRINTPFR(x,y,xpos,ypos) oled.setCursor(xpos,ypos); oled.printf(x,y); oled.printf("\r"); oled.display();
#else
    #define OLED_SETCURS(xpos,ypos)
    #define OLED_CLEAR()
    
    #define OLED_DRAWPIXEL(x, y, color)
    
    #define OLED_PRINT(x)
    #define OLED_PRINTF(x,y)
    #define OLED_PRINTLN(x)
    #define OLED_PRINTLNF(x,y)
    #define OLED_PRINTR(x)
    #define OLED_PRINTFR(x,y)
    
    // Specify position
    #define OLED_PRINTP(x,xpos,ypos)
    #define OLED_PRINTPF(x,y,xpos,ypos)
    #define OLED_PRINTPLN(x,xpos,ypos)
    #define OLED_PRINTPLNF(x,y,xpos,ypos)
    #define OLED_PRINTPR(x,xpos,ypos)
    #define OLED_PRINTPFR(x,y,xpos,ypos)
#endif

extern DS3231 rtc;


#endif // _MAIN_H