#ifndef _DEBUG_H
#define _DEBUG_H

#include "mbed.h"
#include "USBSerial.h"

#define DMP_ERROR_RATE 1
#define SD_ERROR_RATE 2

#define NDEBUG
#ifndef NDEBUG
    /************ On-board LED Access      ****************/
    extern DigitalOut led;
    #define DIE(x) while (1) {led = !led; wait(x);} // Halt program and flash led x times /s
    
    /************ PC Serial Print Commands ****************/
    extern USBSerial pc;
    #define PC_PRINT(x) pc.printf("%s", x);
    #define PC_PRINTF(x,y) pc.printf(x, y);
    #define PC_PRINTLN(x) pc.printf("%s\r\n", x);
    #define PC_PRINTLNF(x,y) pc.printf(x,y); pc.printf("\r\n");
    #define PC_PRINTR(x) pc.printf("%s\r",x);
    #define PC_PRINTFR(x,y) pc.printf(x,y); pc.printf("\r");
#else
    #define DIE(x)

    #define PC_PRINT(x)
    #define PC_PRINTF(x,y)
    #define PC_PRINTLN(x)
    #define PC_PRINTLNF(x,y)
    #define PC_PRINTR(x)
    #define PC_PRINTFR(x,y)
#endif

#endif // _DEBUG_H